@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.AccessGrantArgs.builder
import com.pulumi.aws.s3control.kotlin.inputs.AccessGrantAccessGrantsLocationConfigurationArgs
import com.pulumi.aws.s3control.kotlin.inputs.AccessGrantAccessGrantsLocationConfigurationArgsBuilder
import com.pulumi.aws.s3control.kotlin.inputs.AccessGrantGranteeArgs
import com.pulumi.aws.s3control.kotlin.inputs.AccessGrantGranteeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an S3 Access Grant.
 * Each access grant has its own ID and gives an IAM user or role or a directory user, or group (the grantee) access to a registered location. You determine the level of access, such as `READ` or `READWRITE`.
 * Before you can create a grant, you must have an S3 Access Grants instance in the same Region as the S3 data.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3control.AccessGrantsInstance("example", {});
 * const exampleAccessGrantsLocation = new aws.s3control.AccessGrantsLocation("example", {
 *     iamRoleArn: exampleAwsIamRole.arn,
 *     locationScope: `s3://${exampleAwsS3Bucket.bucket}/prefixA*`,
 * }, {
 *     dependsOn: [example],
 * });
 * const exampleAccessGrant = new aws.s3control.AccessGrant("example", {
 *     accessGrantsLocationId: exampleAccessGrantsLocation.accessGrantsLocationId,
 *     permission: "READ",
 *     accessGrantsLocationConfiguration: {
 *         s3SubPrefix: "prefixB*",
 *     },
 *     grantee: {
 *         granteeType: "IAM",
 *         granteeIdentifier: exampleAwsIamUser.arn,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3control.AccessGrantsInstance("example")
 * example_access_grants_location = aws.s3control.AccessGrantsLocation("example",
 *     iam_role_arn=example_aws_iam_role["arn"],
 *     location_scope=f"s3://{example_aws_s3_bucket['bucket']}/prefixA*",
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * example_access_grant = aws.s3control.AccessGrant("example",
 *     access_grants_location_id=example_access_grants_location.access_grants_location_id,
 *     permission="READ",
 *     access_grants_location_configuration={
 *         "s3_sub_prefix": "prefixB*",
 *     },
 *     grantee={
 *         "grantee_type": "IAM",
 *         "grantee_identifier": example_aws_iam_user["arn"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3Control.AccessGrantsInstance("example");
 *     var exampleAccessGrantsLocation = new Aws.S3Control.AccessGrantsLocation("example", new()
 *     {
 *         IamRoleArn = exampleAwsIamRole.Arn,
 *         LocationScope = $"s3://{exampleAwsS3Bucket.Bucket}/prefixA*",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 *     var exampleAccessGrant = new Aws.S3Control.AccessGrant("example", new()
 *     {
 *         AccessGrantsLocationId = exampleAccessGrantsLocation.AccessGrantsLocationId,
 *         Permission = "READ",
 *         AccessGrantsLocationConfiguration = new Aws.S3Control.Inputs.AccessGrantAccessGrantsLocationConfigurationArgs
 *         {
 *             S3SubPrefix = "prefixB*",
 *         },
 *         Grantee = new Aws.S3Control.Inputs.AccessGrantGranteeArgs
 *         {
 *             GranteeType = "IAM",
 *             GranteeIdentifier = exampleAwsIamUser.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3control"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3control.NewAccessGrantsInstance(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleAccessGrantsLocation, err := s3control.NewAccessGrantsLocation(ctx, "example", &s3control.AccessGrantsLocationArgs{
 * 			IamRoleArn:    pulumi.Any(exampleAwsIamRole.Arn),
 * 			LocationScope: pulumi.Sprintf("s3://%v/prefixA*", exampleAwsS3Bucket.Bucket),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3control.NewAccessGrant(ctx, "example", &s3control.AccessGrantArgs{
 * 			AccessGrantsLocationId: exampleAccessGrantsLocation.AccessGrantsLocationId,
 * 			Permission:             pulumi.String("READ"),
 * 			AccessGrantsLocationConfiguration: &s3control.AccessGrantAccessGrantsLocationConfigurationArgs{
 * 				S3SubPrefix: pulumi.String("prefixB*"),
 * 			},
 * 			Grantee: &s3control.AccessGrantGranteeArgs{
 * 				GranteeType:       pulumi.String("IAM"),
 * 				GranteeIdentifier: pulumi.Any(exampleAwsIamUser.Arn),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3control.AccessGrantsInstance;
 * import com.pulumi.aws.s3control.AccessGrantsLocation;
 * import com.pulumi.aws.s3control.AccessGrantsLocationArgs;
 * import com.pulumi.aws.s3control.AccessGrant;
 * import com.pulumi.aws.s3control.AccessGrantArgs;
 * import com.pulumi.aws.s3control.inputs.AccessGrantAccessGrantsLocationConfigurationArgs;
 * import com.pulumi.aws.s3control.inputs.AccessGrantGranteeArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccessGrantsInstance("example");
 *         var exampleAccessGrantsLocation = new AccessGrantsLocation("exampleAccessGrantsLocation", AccessGrantsLocationArgs.builder()
 *             .iamRoleArn(exampleAwsIamRole.arn())
 *             .locationScope(String.format("s3://%s/prefixA*", exampleAwsS3Bucket.bucket()))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *         var exampleAccessGrant = new AccessGrant("exampleAccessGrant", AccessGrantArgs.builder()
 *             .accessGrantsLocationId(exampleAccessGrantsLocation.accessGrantsLocationId())
 *             .permission("READ")
 *             .accessGrantsLocationConfiguration(AccessGrantAccessGrantsLocationConfigurationArgs.builder()
 *                 .s3SubPrefix("prefixB*")
 *                 .build())
 *             .grantee(AccessGrantGranteeArgs.builder()
 *                 .granteeType("IAM")
 *                 .granteeIdentifier(exampleAwsIamUser.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3control:AccessGrantsInstance
 *   exampleAccessGrantsLocation:
 *     type: aws:s3control:AccessGrantsLocation
 *     name: example
 *     properties:
 *       iamRoleArn: ${exampleAwsIamRole.arn}
 *       locationScope: s3://${exampleAwsS3Bucket.bucket}/prefixA*
 *     options:
 *       dependson:
 *         - ${example}
 *   exampleAccessGrant:
 *     type: aws:s3control:AccessGrant
 *     name: example
 *     properties:
 *       accessGrantsLocationId: ${exampleAccessGrantsLocation.accessGrantsLocationId}
 *       permission: READ
 *       accessGrantsLocationConfiguration:
 *         s3SubPrefix: prefixB*
 *       grantee:
 *         granteeType: IAM
 *         granteeIdentifier: ${exampleAwsIamUser.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import S3 Access Grants using the `account_id` and `access_grant_id`, separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:s3control/accessGrant:AccessGrant example 123456789012,04549c5e-2f3c-4a07-824d-2cafe720aa22
 * ```
 * @property accessGrantsLocationConfiguration See Location Configuration below for more details.
 * @property accessGrantsLocationId The ID of the S3 Access Grants location to with the access grant is giving access.
 * @property accountId
 * @property grantee See Grantee below for more details.
 * @property permission The access grant's level of access. Valid values: `READ`, `WRITE`, `READWRITE`.
 * @property s3PrefixType If you are creating an access grant that grants access to only one object, set this to `Object`. Valid values: `Object`.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AccessGrantArgs(
    public val accessGrantsLocationConfiguration: Output<AccessGrantAccessGrantsLocationConfigurationArgs>? = null,
    public val accessGrantsLocationId: Output<String>? = null,
    public val accountId: Output<String>? = null,
    public val grantee: Output<AccessGrantGranteeArgs>? = null,
    public val permission: Output<String>? = null,
    public val s3PrefixType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3control.AccessGrantArgs> {
    override fun toJava(): com.pulumi.aws.s3control.AccessGrantArgs =
        com.pulumi.aws.s3control.AccessGrantArgs.builder()
            .accessGrantsLocationConfiguration(
                accessGrantsLocationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .accessGrantsLocationId(accessGrantsLocationId?.applyValue({ args0 -> args0 }))
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .grantee(grantee?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .permission(permission?.applyValue({ args0 -> args0 }))
            .s3PrefixType(s3PrefixType?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccessGrantArgs].
 */
@PulumiTagMarker
public class AccessGrantArgsBuilder internal constructor() {
    private var accessGrantsLocationConfiguration:
        Output<AccessGrantAccessGrantsLocationConfigurationArgs>? = null

    private var accessGrantsLocationId: Output<String>? = null

    private var accountId: Output<String>? = null

    private var grantee: Output<AccessGrantGranteeArgs>? = null

    private var permission: Output<String>? = null

    private var s3PrefixType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value See Location Configuration below for more details.
     */
    @JvmName("leajcwwmxfpaahca")
    public suspend fun accessGrantsLocationConfiguration(`value`: Output<AccessGrantAccessGrantsLocationConfigurationArgs>) {
        this.accessGrantsLocationConfiguration = value
    }

    /**
     * @param value The ID of the S3 Access Grants location to with the access grant is giving access.
     */
    @JvmName("hahtjrjbfssexcxj")
    public suspend fun accessGrantsLocationId(`value`: Output<String>) {
        this.accessGrantsLocationId = value
    }

    /**
     * @param value
     */
    @JvmName("dmtgytjvbwxgpyct")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value See Grantee below for more details.
     */
    @JvmName("cctibwnafkhjeqgo")
    public suspend fun grantee(`value`: Output<AccessGrantGranteeArgs>) {
        this.grantee = value
    }

    /**
     * @param value The access grant's level of access. Valid values: `READ`, `WRITE`, `READWRITE`.
     */
    @JvmName("fervbjcqoeafmauq")
    public suspend fun permission(`value`: Output<String>) {
        this.permission = value
    }

    /**
     * @param value If you are creating an access grant that grants access to only one object, set this to `Object`. Valid values: `Object`.
     */
    @JvmName("htxqlxxliarpmock")
    public suspend fun s3PrefixType(`value`: Output<String>) {
        this.s3PrefixType = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jhnwobvebrewkwtn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value See Location Configuration below for more details.
     */
    @JvmName("dvavunjhjsjfmllg")
    public suspend fun accessGrantsLocationConfiguration(`value`: AccessGrantAccessGrantsLocationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessGrantsLocationConfiguration = mapped
    }

    /**
     * @param argument See Location Configuration below for more details.
     */
    @JvmName("nsfgxayrawpewsfc")
    public suspend fun accessGrantsLocationConfiguration(argument: suspend AccessGrantAccessGrantsLocationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AccessGrantAccessGrantsLocationConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.accessGrantsLocationConfiguration = mapped
    }

    /**
     * @param value The ID of the S3 Access Grants location to with the access grant is giving access.
     */
    @JvmName("jightsswpjuiqayn")
    public suspend fun accessGrantsLocationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessGrantsLocationId = mapped
    }

    /**
     * @param value
     */
    @JvmName("gqevhhcnopbndfsf")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value See Grantee below for more details.
     */
    @JvmName("kaghhpwvjdvbilgf")
    public suspend fun grantee(`value`: AccessGrantGranteeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grantee = mapped
    }

    /**
     * @param argument See Grantee below for more details.
     */
    @JvmName("thhheqdkbdojcqtf")
    public suspend fun grantee(argument: suspend AccessGrantGranteeArgsBuilder.() -> Unit) {
        val toBeMapped = AccessGrantGranteeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.grantee = mapped
    }

    /**
     * @param value The access grant's level of access. Valid values: `READ`, `WRITE`, `READWRITE`.
     */
    @JvmName("heiyrqqcgnorresq")
    public suspend fun permission(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permission = mapped
    }

    /**
     * @param value If you are creating an access grant that grants access to only one object, set this to `Object`. Valid values: `Object`.
     */
    @JvmName("oepjdktokddxghoq")
    public suspend fun s3PrefixType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3PrefixType = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bnieygtgrfdnayeg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nyvelfxkwpewtuom")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccessGrantArgs = AccessGrantArgs(
        accessGrantsLocationConfiguration = accessGrantsLocationConfiguration,
        accessGrantsLocationId = accessGrantsLocationId,
        accountId = accountId,
        grantee = grantee,
        permission = permission,
        s3PrefixType = s3PrefixType,
        tags = tags,
    )
}
