@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [AccessGrantsInstance].
 */
@PulumiTagMarker
public class AccessGrantsInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessGrantsInstanceArgs = AccessGrantsInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessGrantsInstanceArgsBuilder.() -> Unit) {
        val builder = AccessGrantsInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessGrantsInstance {
        val builtJavaResource = com.pulumi.aws.s3control.AccessGrantsInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccessGrantsInstance(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an S3 Access Grants instance, which serves as a logical grouping for access grants.
 * You can have one S3 Access Grants instance per Region in your account.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3control.AccessGrantsInstance("example", {});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3control.AccessGrantsInstance("example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3Control.AccessGrantsInstance("example");
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3control"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := s3control.NewAccessGrantsInstance(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3control.AccessGrantsInstance;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccessGrantsInstance("example");
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3control:AccessGrantsInstance
 * ```
 * <!--End PulumiCodeChooser -->
 * ### AWS IAM Identity Center
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3control.AccessGrantsInstance("example", {identityCenterArn: "arn:aws:sso:::instance/ssoins-890759e9c7bfdc1d"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3control.AccessGrantsInstance("example", identity_center_arn="arn:aws:sso:::instance/ssoins-890759e9c7bfdc1d")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3Control.AccessGrantsInstance("example", new()
 *     {
 *         IdentityCenterArn = "arn:aws:sso:::instance/ssoins-890759e9c7bfdc1d",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3control"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := s3control.NewAccessGrantsInstance(ctx, "example", &s3control.AccessGrantsInstanceArgs{
 * 			IdentityCenterArn: pulumi.String("arn:aws:sso:::instance/ssoins-890759e9c7bfdc1d"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3control.AccessGrantsInstance;
 * import com.pulumi.aws.s3control.AccessGrantsInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccessGrantsInstance("example", AccessGrantsInstanceArgs.builder()
 *             .identityCenterArn("arn:aws:sso:::instance/ssoins-890759e9c7bfdc1d")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3control:AccessGrantsInstance
 *     properties:
 *       identityCenterArn: arn:aws:sso:::instance/ssoins-890759e9c7bfdc1d
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import S3 Access Grants instances using the `account_id`. For example:
 * ```sh
 * $ pulumi import aws:s3control/accessGrantsInstance:AccessGrantsInstance example 123456789012
 * ```
 */
public class AccessGrantsInstance internal constructor(
    override val javaResource: com.pulumi.aws.s3control.AccessGrantsInstance,
) : KotlinCustomResource(javaResource, AccessGrantsInstanceMapper) {
    /**
     * Amazon Resource Name (ARN) of the S3 Access Grants instance.
     */
    public val accessGrantsInstanceArn: Output<String>
        get() = javaResource.accessGrantsInstanceArn().applyValue({ args0 -> args0 })

    /**
     * Unique ID of the S3 Access Grants instance.
     */
    public val accessGrantsInstanceId: Output<String>
        get() = javaResource.accessGrantsInstanceId().applyValue({ args0 -> args0 })

    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The ARN of the AWS IAM Identity Center instance application; a subresource of the original Identity Center instance.
     */
    public val identityCenterApplicationArn: Output<String>
        get() = javaResource.identityCenterApplicationArn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the AWS IAM Identity Center instance associated with the S3 Access Grants instance.
     */
    public val identityCenterArn: Output<String>?
        get() = javaResource.identityCenterArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object AccessGrantsInstanceMapper : ResourceMapper<AccessGrantsInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3control.AccessGrantsInstance::class == javaResource::class

    override fun map(javaResource: Resource): AccessGrantsInstance = AccessGrantsInstance(
        javaResource
            as com.pulumi.aws.s3control.AccessGrantsInstance,
    )
}

/**
 * @see [AccessGrantsInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessGrantsInstance].
 */
public suspend fun accessGrantsInstance(
    name: String,
    block: suspend AccessGrantsInstanceResourceBuilder.() -> Unit,
): AccessGrantsInstance {
    val builder = AccessGrantsInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessGrantsInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessGrantsInstance(name: String): AccessGrantsInstance {
    val builder = AccessGrantsInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
