@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccessGrantsInstanceResourcePolicy].
 */
@PulumiTagMarker
public class AccessGrantsInstanceResourcePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessGrantsInstanceResourcePolicyArgs = AccessGrantsInstanceResourcePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessGrantsInstanceResourcePolicyArgsBuilder.() -> Unit) {
        val builder = AccessGrantsInstanceResourcePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessGrantsInstanceResourcePolicy {
        val builtJavaResource =
            com.pulumi.aws.s3control.AccessGrantsInstanceResourcePolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AccessGrantsInstanceResourcePolicy(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an S3 Access Grants instance resource policy.
 * Use a resource policy to manage cross-account access to your S3 Access Grants instance.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3control.AccessGrantsInstance("example", {});
 * const exampleAccessGrantsInstanceResourcePolicy = new aws.s3control.AccessGrantsInstanceResourcePolicy("example", {policy: pulumi.interpolate`{
 *   "Version": "2012-10-17",
 *   "Id": "S3AccessGrantsPolicy",
 *   "Statement": [{
 *     "Sid": "AllowAccessToS3AccessGrants",
 *     "Effect": "Allow",
 *     "Principal": {
 *       "AWS": "123456789456"
 *     },
 *     "Action": [
 *       "s3:ListAccessGrants",
 *       "s3:ListAccessGrantsLocations",
 *       "s3:GetDataAccess"
 *     ],
 *     "Resource": "${example.accessGrantsInstanceArn}"
 *   }]
 * }
 * `});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3control.AccessGrantsInstance("example")
 * example_access_grants_instance_resource_policy = aws.s3control.AccessGrantsInstanceResourcePolicy("example", policy=example.access_grants_instance_arn.apply(lambda access_grants_instance_arn: f"""{{
 *   "Version": "2012-10-17",
 *   "Id": "S3AccessGrantsPolicy",
 *   "Statement": [{{
 *     "Sid": "AllowAccessToS3AccessGrants",
 *     "Effect": "Allow",
 *     "Principal": {{
 *       "AWS": "123456789456"
 *     }},
 *     "Action": [
 *       "s3:ListAccessGrants",
 *       "s3:ListAccessGrantsLocations",
 *       "s3:GetDataAccess"
 *     ],
 *     "Resource": "{access_grants_instance_arn}"
 *   }}]
 * }}
 * """))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3Control.AccessGrantsInstance("example");
 *     var exampleAccessGrantsInstanceResourcePolicy = new Aws.S3Control.AccessGrantsInstanceResourcePolicy("example", new()
 *     {
 *         Policy = example.AccessGrantsInstanceArn.Apply(accessGrantsInstanceArn => @$"{{
 *   ""Version"": ""2012-10-17"",
 *   ""Id"": ""S3AccessGrantsPolicy"",
 *   ""Statement"": [{{
 *     ""Sid"": ""AllowAccessToS3AccessGrants"",
 *     ""Effect"": ""Allow"",
 *     ""Principal"": {{
 *       ""AWS"": ""123456789456""
 *     }},
 *     ""Action"": [
 *       ""s3:ListAccessGrants"",
 *       ""s3:ListAccessGrantsLocations"",
 *       ""s3:GetDataAccess""
 *     ],
 *     ""Resource"": ""{accessGrantsInstanceArn}""
 *   }}]
 * }}
 * "),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3control"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3control.NewAccessGrantsInstance(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3control.NewAccessGrantsInstanceResourcePolicy(ctx, "example", &s3control.AccessGrantsInstanceResourcePolicyArgs{
 * 			Policy: example.AccessGrantsInstanceArn.ApplyT(func(accessGrantsInstanceArn string) (string, error) {
 * 				return fmt.Sprintf(`{
 *   "Version": "2012-10-17",
 *   "Id": "S3AccessGrantsPolicy",
 *   "Statement": [{
 *     "Sid": "AllowAccessToS3AccessGrants",
 *     "Effect": "Allow",
 *     "Principal": {
 *       "AWS": "123456789456"
 *     },
 *     "Action": [
 *       "s3:ListAccessGrants",
 *       "s3:ListAccessGrantsLocations",
 *       "s3:GetDataAccess"
 *     ],
 *     "Resource": "%v"
 *   }]
 * }
 * `, accessGrantsInstanceArn), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3control.AccessGrantsInstance;
 * import com.pulumi.aws.s3control.AccessGrantsInstanceResourcePolicy;
 * import com.pulumi.aws.s3control.AccessGrantsInstanceResourcePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccessGrantsInstance("example");
 *         var exampleAccessGrantsInstanceResourcePolicy = new AccessGrantsInstanceResourcePolicy("exampleAccessGrantsInstanceResourcePolicy", AccessGrantsInstanceResourcePolicyArgs.builder()
 *             .policy(example.accessGrantsInstanceArn().applyValue(accessGrantsInstanceArn -> """
 * {
 *   "Version": "2012-10-17",
 *   "Id": "S3AccessGrantsPolicy",
 *   "Statement": [{
 *     "Sid": "AllowAccessToS3AccessGrants",
 *     "Effect": "Allow",
 *     "Principal": {
 *       "AWS": "123456789456"
 *     },
 *     "Action": [
 *       "s3:ListAccessGrants",
 *       "s3:ListAccessGrantsLocations",
 *       "s3:GetDataAccess"
 *     ],
 *     "Resource": "%s"
 *   }]
 * }
 * ", accessGrantsInstanceArn)))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3control:AccessGrantsInstance
 *   exampleAccessGrantsInstanceResourcePolicy:
 *     type: aws:s3control:AccessGrantsInstanceResourcePolicy
 *     name: example
 *     properties:
 *       policy: |
 *         {
 *           "Version": "2012-10-17",
 *           "Id": "S3AccessGrantsPolicy",
 *           "Statement": [{
 *             "Sid": "AllowAccessToS3AccessGrants",
 *             "Effect": "Allow",
 *             "Principal": {
 *               "AWS": "123456789456"
 *             },
 *             "Action": [
 *               "s3:ListAccessGrants",
 *               "s3:ListAccessGrantsLocations",
 *               "s3:GetDataAccess"
 *             ],
 *             "Resource": "${example.accessGrantsInstanceArn}"
 *           }]
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import S3 Access Grants instance resource policies using the `account_id`. For example:
 * ```sh
 * $ pulumi import aws:s3control/accessGrantsInstanceResourcePolicy:AccessGrantsInstanceResourcePolicy example 123456789012
 * ```
 */
public class AccessGrantsInstanceResourcePolicy internal constructor(
    override val javaResource: com.pulumi.aws.s3control.AccessGrantsInstanceResourcePolicy,
) : KotlinCustomResource(javaResource, AccessGrantsInstanceResourcePolicyMapper) {
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The policy document.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object AccessGrantsInstanceResourcePolicyMapper :
    ResourceMapper<AccessGrantsInstanceResourcePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3control.AccessGrantsInstanceResourcePolicy::class == javaResource::class

    override fun map(javaResource: Resource): AccessGrantsInstanceResourcePolicy =
        AccessGrantsInstanceResourcePolicy(
            javaResource as
                com.pulumi.aws.s3control.AccessGrantsInstanceResourcePolicy,
        )
}

/**
 * @see [AccessGrantsInstanceResourcePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessGrantsInstanceResourcePolicy].
 */
public suspend fun accessGrantsInstanceResourcePolicy(
    name: String,
    block: suspend AccessGrantsInstanceResourcePolicyResourceBuilder.() -> Unit,
): AccessGrantsInstanceResourcePolicy {
    val builder = AccessGrantsInstanceResourcePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessGrantsInstanceResourcePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessGrantsInstanceResourcePolicy(name: String): AccessGrantsInstanceResourcePolicy {
    val builder = AccessGrantsInstanceResourcePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
