@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [AccessGrantsLocation].
 */
@PulumiTagMarker
public class AccessGrantsLocationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessGrantsLocationArgs = AccessGrantsLocationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessGrantsLocationArgsBuilder.() -> Unit) {
        val builder = AccessGrantsLocationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessGrantsLocation {
        val builtJavaResource = com.pulumi.aws.s3control.AccessGrantsLocation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccessGrantsLocation(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an S3 Access Grants location.
 * A location is an S3 resource (bucket or prefix) in a permission grant that the grantee can access.
 * The S3 data must be in the same Region as your S3 Access Grants instance.
 * When you register a location, you must include the IAM role that has permission to manage the S3 location that you are registering.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3control.AccessGrantsInstance("example", {});
 * const exampleAccessGrantsLocation = new aws.s3control.AccessGrantsLocation("example", {
 *     iamRoleArn: exampleAwsIamRole.arn,
 *     locationScope: "s3://",
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3control.AccessGrantsInstance("example")
 * example_access_grants_location = aws.s3control.AccessGrantsLocation("example",
 *     iam_role_arn=example_aws_iam_role["arn"],
 *     location_scope="s3://",
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3Control.AccessGrantsInstance("example");
 *     var exampleAccessGrantsLocation = new Aws.S3Control.AccessGrantsLocation("example", new()
 *     {
 *         IamRoleArn = exampleAwsIamRole.Arn,
 *         LocationScope = "s3://",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3control"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3control.NewAccessGrantsInstance(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3control.NewAccessGrantsLocation(ctx, "example", &s3control.AccessGrantsLocationArgs{
 * 			IamRoleArn:    pulumi.Any(exampleAwsIamRole.Arn),
 * 			LocationScope: pulumi.String("s3://"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3control.AccessGrantsInstance;
 * import com.pulumi.aws.s3control.AccessGrantsLocation;
 * import com.pulumi.aws.s3control.AccessGrantsLocationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccessGrantsInstance("example");
 *         var exampleAccessGrantsLocation = new AccessGrantsLocation("exampleAccessGrantsLocation", AccessGrantsLocationArgs.builder()
 *             .iamRoleArn(exampleAwsIamRole.arn())
 *             .locationScope("s3://")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3control:AccessGrantsInstance
 *   exampleAccessGrantsLocation:
 *     type: aws:s3control:AccessGrantsLocation
 *     name: example
 *     properties:
 *       iamRoleArn: ${exampleAwsIamRole.arn}
 *       locationScope: s3://
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import S3 Access Grants locations using the `account_id` and `access_grants_location_id`, separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:s3control/accessGrantsLocation:AccessGrantsLocation example 123456789012,default
 * ```
 */
public class AccessGrantsLocation internal constructor(
    override val javaResource: com.pulumi.aws.s3control.AccessGrantsLocation,
) : KotlinCustomResource(javaResource, AccessGrantsLocationMapper) {
    /**
     * Amazon Resource Name (ARN) of the S3 Access Grants location.
     */
    public val accessGrantsLocationArn: Output<String>
        get() = javaResource.accessGrantsLocationArn().applyValue({ args0 -> args0 })

    /**
     * Unique ID of the S3 Access Grants location.
     */
    public val accessGrantsLocationId: Output<String>
        get() = javaResource.accessGrantsLocationId().applyValue({ args0 -> args0 })

    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The ARN of the IAM role that S3 Access Grants should use when fulfilling runtime access
     * requests to the location.
     */
    public val iamRoleArn: Output<String>
        get() = javaResource.iamRoleArn().applyValue({ args0 -> args0 })

    /**
     * The default S3 URI `s3://` or the URI to a custom location, a specific bucket or prefix.
     */
    public val locationScope: Output<String>
        get() = javaResource.locationScope().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object AccessGrantsLocationMapper : ResourceMapper<AccessGrantsLocation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3control.AccessGrantsLocation::class == javaResource::class

    override fun map(javaResource: Resource): AccessGrantsLocation = AccessGrantsLocation(
        javaResource
            as com.pulumi.aws.s3control.AccessGrantsLocation,
    )
}

/**
 * @see [AccessGrantsLocation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessGrantsLocation].
 */
public suspend fun accessGrantsLocation(
    name: String,
    block: suspend AccessGrantsLocationResourceBuilder.() -> Unit,
): AccessGrantsLocation {
    val builder = AccessGrantsLocationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessGrantsLocation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessGrantsLocation(name: String): AccessGrantsLocation {
    val builder = AccessGrantsLocationResourceBuilder()
    builder.name(name)
    return builder.build()
}
