@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.AccessGrantsLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an S3 Access Grants location.
 * A location is an S3 resource (bucket or prefix) in a permission grant that the grantee can access.
 * The S3 data must be in the same Region as your S3 Access Grants instance.
 * When you register a location, you must include the IAM role that has permission to manage the S3 location that you are registering.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3control.AccessGrantsInstance("example", {});
 * const exampleAccessGrantsLocation = new aws.s3control.AccessGrantsLocation("example", {
 *     iamRoleArn: exampleAwsIamRole.arn,
 *     locationScope: "s3://",
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3control.AccessGrantsInstance("example")
 * example_access_grants_location = aws.s3control.AccessGrantsLocation("example",
 *     iam_role_arn=example_aws_iam_role["arn"],
 *     location_scope="s3://",
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3Control.AccessGrantsInstance("example");
 *     var exampleAccessGrantsLocation = new Aws.S3Control.AccessGrantsLocation("example", new()
 *     {
 *         IamRoleArn = exampleAwsIamRole.Arn,
 *         LocationScope = "s3://",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3control"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3control.NewAccessGrantsInstance(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3control.NewAccessGrantsLocation(ctx, "example", &s3control.AccessGrantsLocationArgs{
 * 			IamRoleArn:    pulumi.Any(exampleAwsIamRole.Arn),
 * 			LocationScope: pulumi.String("s3://"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3control.AccessGrantsInstance;
 * import com.pulumi.aws.s3control.AccessGrantsLocation;
 * import com.pulumi.aws.s3control.AccessGrantsLocationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccessGrantsInstance("example");
 *         var exampleAccessGrantsLocation = new AccessGrantsLocation("exampleAccessGrantsLocation", AccessGrantsLocationArgs.builder()
 *             .iamRoleArn(exampleAwsIamRole.arn())
 *             .locationScope("s3://")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3control:AccessGrantsInstance
 *   exampleAccessGrantsLocation:
 *     type: aws:s3control:AccessGrantsLocation
 *     name: example
 *     properties:
 *       iamRoleArn: ${exampleAwsIamRole.arn}
 *       locationScope: s3://
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import S3 Access Grants locations using the `account_id` and `access_grants_location_id`, separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:s3control/accessGrantsLocation:AccessGrantsLocation example 123456789012,default
 * ```
 * @property accountId
 * @property iamRoleArn The ARN of the IAM role that S3 Access Grants should use when fulfilling runtime access
 * requests to the location.
 * @property locationScope The default S3 URI `s3://` or the URI to a custom location, a specific bucket or prefix.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AccessGrantsLocationArgs(
    public val accountId: Output<String>? = null,
    public val iamRoleArn: Output<String>? = null,
    public val locationScope: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3control.AccessGrantsLocationArgs> {
    override fun toJava(): com.pulumi.aws.s3control.AccessGrantsLocationArgs =
        com.pulumi.aws.s3control.AccessGrantsLocationArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .iamRoleArn(iamRoleArn?.applyValue({ args0 -> args0 }))
            .locationScope(locationScope?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccessGrantsLocationArgs].
 */
@PulumiTagMarker
public class AccessGrantsLocationArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var iamRoleArn: Output<String>? = null

    private var locationScope: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("vhuqmxjassgsafcw")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The ARN of the IAM role that S3 Access Grants should use when fulfilling runtime access
     * requests to the location.
     */
    @JvmName("ufcwohxynqripysv")
    public suspend fun iamRoleArn(`value`: Output<String>) {
        this.iamRoleArn = value
    }

    /**
     * @param value The default S3 URI `s3://` or the URI to a custom location, a specific bucket or prefix.
     */
    @JvmName("cicfcnxmuakpbqbp")
    public suspend fun locationScope(`value`: Output<String>) {
        this.locationScope = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iaawltepakehccyv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("qtsdijpwlvitdluy")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The ARN of the IAM role that S3 Access Grants should use when fulfilling runtime access
     * requests to the location.
     */
    @JvmName("ddwuajvjkoxaprfu")
    public suspend fun iamRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRoleArn = mapped
    }

    /**
     * @param value The default S3 URI `s3://` or the URI to a custom location, a specific bucket or prefix.
     */
    @JvmName("axrcrqaevhmbapsk")
    public suspend fun locationScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locationScope = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("utfrmyrdnyfrutqr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("evuotabxaygkympn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccessGrantsLocationArgs = AccessGrantsLocationArgs(
        accountId = accountId,
        iamRoleArn = iamRoleArn,
        locationScope = locationScope,
        tags = tags,
    )
}
