@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.MultiRegionAccessPointArgs.builder
import com.pulumi.aws.s3control.kotlin.inputs.MultiRegionAccessPointDetailsArgs
import com.pulumi.aws.s3control.kotlin.inputs.MultiRegionAccessPointDetailsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an S3 Multi-Region Access Point associated with specified buckets.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Multiple AWS Buckets in Different Regions
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const fooBucket = new aws.s3.BucketV2("foo_bucket", {bucket: "example-bucket-foo"});
 * const barBucket = new aws.s3.BucketV2("bar_bucket", {bucket: "example-bucket-bar"});
 * const example = new aws.s3control.MultiRegionAccessPoint("example", {details: {
 *     name: "example",
 *     regions: [
 *         {
 *             bucket: fooBucket.id,
 *         },
 *         {
 *             bucket: barBucket.id,
 *         },
 *     ],
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo_bucket = aws.s3.BucketV2("foo_bucket", bucket="example-bucket-foo")
 * bar_bucket = aws.s3.BucketV2("bar_bucket", bucket="example-bucket-bar")
 * example = aws.s3control.MultiRegionAccessPoint("example", details={
 *     "name": "example",
 *     "regions": [
 *         {
 *             "bucket": foo_bucket.id,
 *         },
 *         {
 *             "bucket": bar_bucket.id,
 *         },
 *     ],
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fooBucket = new Aws.S3.BucketV2("foo_bucket", new()
 *     {
 *         Bucket = "example-bucket-foo",
 *     });
 *     var barBucket = new Aws.S3.BucketV2("bar_bucket", new()
 *     {
 *         Bucket = "example-bucket-bar",
 *     });
 *     var example = new Aws.S3Control.MultiRegionAccessPoint("example", new()
 *     {
 *         Details = new Aws.S3Control.Inputs.MultiRegionAccessPointDetailsArgs
 *         {
 *             Name = "example",
 *             Regions = new[]
 *             {
 *                 new Aws.S3Control.Inputs.MultiRegionAccessPointDetailsRegionArgs
 *                 {
 *                     Bucket = fooBucket.Id,
 *                 },
 *                 new Aws.S3Control.Inputs.MultiRegionAccessPointDetailsRegionArgs
 *                 {
 *                     Bucket = barBucket.Id,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3control"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		fooBucket, err := s3.NewBucketV2(ctx, "foo_bucket", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example-bucket-foo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		barBucket, err := s3.NewBucketV2(ctx, "bar_bucket", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example-bucket-bar"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3control.NewMultiRegionAccessPoint(ctx, "example", &s3control.MultiRegionAccessPointArgs{
 * 			Details: &s3control.MultiRegionAccessPointDetailsArgs{
 * 				Name: pulumi.String("example"),
 * 				Regions: s3control.MultiRegionAccessPointDetailsRegionArray{
 * 					&s3control.MultiRegionAccessPointDetailsRegionArgs{
 * 						Bucket: fooBucket.ID(),
 * 					},
 * 					&s3control.MultiRegionAccessPointDetailsRegionArgs{
 * 						Bucket: barBucket.ID(),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3control.MultiRegionAccessPoint;
 * import com.pulumi.aws.s3control.MultiRegionAccessPointArgs;
 * import com.pulumi.aws.s3control.inputs.MultiRegionAccessPointDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fooBucket = new BucketV2("fooBucket", BucketV2Args.builder()
 *             .bucket("example-bucket-foo")
 *             .build());
 *         var barBucket = new BucketV2("barBucket", BucketV2Args.builder()
 *             .bucket("example-bucket-bar")
 *             .build());
 *         var example = new MultiRegionAccessPoint("example", MultiRegionAccessPointArgs.builder()
 *             .details(MultiRegionAccessPointDetailsArgs.builder()
 *                 .name("example")
 *                 .regions(
 *                     MultiRegionAccessPointDetailsRegionArgs.builder()
 *                         .bucket(fooBucket.id())
 *                         .build(),
 *                     MultiRegionAccessPointDetailsRegionArgs.builder()
 *                         .bucket(barBucket.id())
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   fooBucket:
 *     type: aws:s3:BucketV2
 *     name: foo_bucket
 *     properties:
 *       bucket: example-bucket-foo
 *   barBucket:
 *     type: aws:s3:BucketV2
 *     name: bar_bucket
 *     properties:
 *       bucket: example-bucket-bar
 *   example:
 *     type: aws:s3control:MultiRegionAccessPoint
 *     properties:
 *       details:
 *         name: example
 *         regions:
 *           - bucket: ${fooBucket.id}
 *           - bucket: ${barBucket.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Multi-Region Access Points using the `account_id` and `name` of the Multi-Region Access Point separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:s3control/multiRegionAccessPoint:MultiRegionAccessPoint example 123456789012:example
 * ```
 * @property accountId The AWS account ID for the owner of the buckets for which you want to create a Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
 * @property details A configuration block containing details about the Multi-Region Access Point. See Details Configuration Block below for more details
 */
public data class MultiRegionAccessPointArgs(
    public val accountId: Output<String>? = null,
    public val details: Output<MultiRegionAccessPointDetailsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3control.MultiRegionAccessPointArgs> {
    override fun toJava(): com.pulumi.aws.s3control.MultiRegionAccessPointArgs =
        com.pulumi.aws.s3control.MultiRegionAccessPointArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .details(details?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MultiRegionAccessPointArgs].
 */
@PulumiTagMarker
public class MultiRegionAccessPointArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var details: Output<MultiRegionAccessPointDetailsArgs>? = null

    /**
     * @param value The AWS account ID for the owner of the buckets for which you want to create a Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("yeyllsbccahcgaod")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value A configuration block containing details about the Multi-Region Access Point. See Details Configuration Block below for more details
     */
    @JvmName("qmqprtlpuvirkubl")
    public suspend fun details(`value`: Output<MultiRegionAccessPointDetailsArgs>) {
        this.details = value
    }

    /**
     * @param value The AWS account ID for the owner of the buckets for which you want to create a Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("ligkqnpbuqueveel")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value A configuration block containing details about the Multi-Region Access Point. See Details Configuration Block below for more details
     */
    @JvmName("njapoayaobatovqg")
    public suspend fun details(`value`: MultiRegionAccessPointDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.details = mapped
    }

    /**
     * @param argument A configuration block containing details about the Multi-Region Access Point. See Details Configuration Block below for more details
     */
    @JvmName("lbypesglsimoajkx")
    public suspend fun details(argument: suspend MultiRegionAccessPointDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = MultiRegionAccessPointDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.details = mapped
    }

    internal fun build(): MultiRegionAccessPointArgs = MultiRegionAccessPointArgs(
        accountId = accountId,
        details = details,
    )
}
