@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.kotlin.outputs.MultiRegionAccessPointPolicyDetails
import com.pulumi.aws.s3control.kotlin.outputs.MultiRegionAccessPointPolicyDetails.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MultiRegionAccessPointPolicy].
 */
@PulumiTagMarker
public class MultiRegionAccessPointPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MultiRegionAccessPointPolicyArgs = MultiRegionAccessPointPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MultiRegionAccessPointPolicyArgsBuilder.() -> Unit) {
        val builder = MultiRegionAccessPointPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MultiRegionAccessPointPolicy {
        val builtJavaResource =
            com.pulumi.aws.s3control.MultiRegionAccessPointPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MultiRegionAccessPointPolicy(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an S3 Multi-Region Access Point access control policy.
 * ## Example Usage
 * ## Import
 * Using `pulumi import`, import Multi-Region Access Point Policies using the `account_id` and `name` of the Multi-Region Access Point separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:s3control/multiRegionAccessPointPolicy:MultiRegionAccessPointPolicy example 123456789012:example
 * ```
 */
public class MultiRegionAccessPointPolicy internal constructor(
    override val javaResource: com.pulumi.aws.s3control.MultiRegionAccessPointPolicy,
) : KotlinCustomResource(javaResource, MultiRegionAccessPointPolicyMapper) {
    /**
     * The AWS account ID for the owner of the Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * A configuration block containing details about the policy for the Multi-Region Access Point. See Details Configuration Block below for more details
     */
    public val details: Output<MultiRegionAccessPointPolicyDetails>
        get() = javaResource.details().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The last established policy for the Multi-Region Access Point.
     */
    public val established: Output<String>
        get() = javaResource.established().applyValue({ args0 -> args0 })

    /**
     * The proposed policy for the Multi-Region Access Point.
     */
    public val proposed: Output<String>
        get() = javaResource.proposed().applyValue({ args0 -> args0 })
}

public object MultiRegionAccessPointPolicyMapper : ResourceMapper<MultiRegionAccessPointPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3control.MultiRegionAccessPointPolicy::class == javaResource::class

    override fun map(javaResource: Resource): MultiRegionAccessPointPolicy =
        MultiRegionAccessPointPolicy(
            javaResource as
                com.pulumi.aws.s3control.MultiRegionAccessPointPolicy,
        )
}

/**
 * @see [MultiRegionAccessPointPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MultiRegionAccessPointPolicy].
 */
public suspend fun multiRegionAccessPointPolicy(
    name: String,
    block: suspend MultiRegionAccessPointPolicyResourceBuilder.() -> Unit,
): MultiRegionAccessPointPolicy {
    val builder = MultiRegionAccessPointPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MultiRegionAccessPointPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun multiRegionAccessPointPolicy(name: String): MultiRegionAccessPointPolicy {
    val builder = MultiRegionAccessPointPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
