@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.MultiRegionAccessPointPolicyArgs.builder
import com.pulumi.aws.s3control.kotlin.inputs.MultiRegionAccessPointPolicyDetailsArgs
import com.pulumi.aws.s3control.kotlin.inputs.MultiRegionAccessPointPolicyDetailsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an S3 Multi-Region Access Point access control policy.
 * ## Example Usage
 * ## Import
 * Using `pulumi import`, import Multi-Region Access Point Policies using the `account_id` and `name` of the Multi-Region Access Point separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:s3control/multiRegionAccessPointPolicy:MultiRegionAccessPointPolicy example 123456789012:example
 * ```
 * @property accountId The AWS account ID for the owner of the Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
 * @property details A configuration block containing details about the policy for the Multi-Region Access Point. See Details Configuration Block below for more details
 */
public data class MultiRegionAccessPointPolicyArgs(
    public val accountId: Output<String>? = null,
    public val details: Output<MultiRegionAccessPointPolicyDetailsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3control.MultiRegionAccessPointPolicyArgs> {
    override fun toJava(): com.pulumi.aws.s3control.MultiRegionAccessPointPolicyArgs =
        com.pulumi.aws.s3control.MultiRegionAccessPointPolicyArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .details(details?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MultiRegionAccessPointPolicyArgs].
 */
@PulumiTagMarker
public class MultiRegionAccessPointPolicyArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var details: Output<MultiRegionAccessPointPolicyDetailsArgs>? = null

    /**
     * @param value The AWS account ID for the owner of the Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("aaxnldjxycqhxixu")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value A configuration block containing details about the policy for the Multi-Region Access Point. See Details Configuration Block below for more details
     */
    @JvmName("ikmuahpytxnsojtr")
    public suspend fun details(`value`: Output<MultiRegionAccessPointPolicyDetailsArgs>) {
        this.details = value
    }

    /**
     * @param value The AWS account ID for the owner of the Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("lwocjgxpdeolyyon")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value A configuration block containing details about the policy for the Multi-Region Access Point. See Details Configuration Block below for more details
     */
    @JvmName("rsruafejqntemucc")
    public suspend fun details(`value`: MultiRegionAccessPointPolicyDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.details = mapped
    }

    /**
     * @param argument A configuration block containing details about the policy for the Multi-Region Access Point. See Details Configuration Block below for more details
     */
    @JvmName("nafjuseiccumnvnr")
    public suspend fun details(argument: suspend MultiRegionAccessPointPolicyDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = MultiRegionAccessPointPolicyDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.details = mapped
    }

    internal fun build(): MultiRegionAccessPointPolicyArgs = MultiRegionAccessPointPolicyArgs(
        accountId = accountId,
        details = details,
    )
}
