@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.ObjectLambdaAccessPointArgs.builder
import com.pulumi.aws.s3control.kotlin.inputs.ObjectLambdaAccessPointConfigurationArgs
import com.pulumi.aws.s3control.kotlin.inputs.ObjectLambdaAccessPointConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an S3 Object Lambda Access Point.
 * An Object Lambda access point is associated with exactly one standard access point and thus one Amazon S3 bucket.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {bucket: "example"});
 * const exampleAccessPoint = new aws.s3.AccessPoint("example", {
 *     bucket: example.id,
 *     name: "example",
 * });
 * const exampleObjectLambdaAccessPoint = new aws.s3control.ObjectLambdaAccessPoint("example", {
 *     name: "example",
 *     configuration: {
 *         supportingAccessPoint: exampleAccessPoint.arn,
 *         transformationConfigurations: [{
 *             actions: ["GetObject"],
 *             contentTransformation: {
 *                 awsLambda: {
 *                     functionArn: exampleAwsLambdaFunction.arn,
 *                 },
 *             },
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example", bucket="example")
 * example_access_point = aws.s3.AccessPoint("example",
 *     bucket=example.id,
 *     name="example")
 * example_object_lambda_access_point = aws.s3control.ObjectLambdaAccessPoint("example",
 *     name="example",
 *     configuration={
 *         "supporting_access_point": example_access_point.arn,
 *         "transformation_configurations": [{
 *             "actions": ["GetObject"],
 *             "content_transformation": {
 *                 "aws_lambda": {
 *                     "function_arn": example_aws_lambda_function["arn"],
 *                 },
 *             },
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *     });
 *     var exampleAccessPoint = new Aws.S3.AccessPoint("example", new()
 *     {
 *         Bucket = example.Id,
 *         Name = "example",
 *     });
 *     var exampleObjectLambdaAccessPoint = new Aws.S3Control.ObjectLambdaAccessPoint("example", new()
 *     {
 *         Name = "example",
 *         Configuration = new Aws.S3Control.Inputs.ObjectLambdaAccessPointConfigurationArgs
 *         {
 *             SupportingAccessPoint = exampleAccessPoint.Arn,
 *             TransformationConfigurations = new[]
 *             {
 *                 new Aws.S3Control.Inputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs
 *                 {
 *                     Actions = new[]
 *                     {
 *                         "GetObject",
 *                     },
 *                     ContentTransformation = new Aws.S3Control.Inputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs
 *                     {
 *                         AwsLambda = new Aws.S3Control.Inputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs
 *                         {
 *                             FunctionArn = exampleAwsLambdaFunction.Arn,
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3control"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleAccessPoint, err := s3.NewAccessPoint(ctx, "example", &s3.AccessPointArgs{
 * 			Bucket: example.ID(),
 * 			Name:   pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3control.NewObjectLambdaAccessPoint(ctx, "example", &s3control.ObjectLambdaAccessPointArgs{
 * 			Name: pulumi.String("example"),
 * 			Configuration: &s3control.ObjectLambdaAccessPointConfigurationArgs{
 * 				SupportingAccessPoint: exampleAccessPoint.Arn,
 * 				TransformationConfigurations: s3control.ObjectLambdaAccessPointConfigurationTransformationConfigurationArray{
 * 					&s3control.ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs{
 * 						Actions: pulumi.StringArray{
 * 							pulumi.String("GetObject"),
 * 						},
 * 						ContentTransformation: &s3control.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs{
 * 							AwsLambda: &s3control.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs{
 * 								FunctionArn: pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.AccessPoint;
 * import com.pulumi.aws.s3.AccessPointArgs;
 * import com.pulumi.aws.s3control.ObjectLambdaAccessPoint;
 * import com.pulumi.aws.s3control.ObjectLambdaAccessPointArgs;
 * import com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("example")
 *             .build());
 *         var exampleAccessPoint = new AccessPoint("exampleAccessPoint", AccessPointArgs.builder()
 *             .bucket(example.id())
 *             .name("example")
 *             .build());
 *         var exampleObjectLambdaAccessPoint = new ObjectLambdaAccessPoint("exampleObjectLambdaAccessPoint", ObjectLambdaAccessPointArgs.builder()
 *             .name("example")
 *             .configuration(ObjectLambdaAccessPointConfigurationArgs.builder()
 *                 .supportingAccessPoint(exampleAccessPoint.arn())
 *                 .transformationConfigurations(ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs.builder()
 *                     .actions("GetObject")
 *                     .contentTransformation(ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs.builder()
 *                         .awsLambda(ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs.builder()
 *                             .functionArn(exampleAwsLambdaFunction.arn())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example
 *   exampleAccessPoint:
 *     type: aws:s3:AccessPoint
 *     name: example
 *     properties:
 *       bucket: ${example.id}
 *       name: example
 *   exampleObjectLambdaAccessPoint:
 *     type: aws:s3control:ObjectLambdaAccessPoint
 *     name: example
 *     properties:
 *       name: example
 *       configuration:
 *         supportingAccessPoint: ${exampleAccessPoint.arn}
 *         transformationConfigurations:
 *           - actions:
 *               - GetObject
 *             contentTransformation:
 *               awsLambda:
 *                 functionArn: ${exampleAwsLambdaFunction.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Object Lambda Access Points using the `account_id` and `name`, separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:s3control/objectLambdaAccessPoint:ObjectLambdaAccessPoint example 123456789012:example
 * ```
 * @property accountId The AWS account ID for the owner of the bucket for which you want to create an Object Lambda Access Point. Defaults to automatically determined account ID of the AWS provider.
 * @property configuration A configuration block containing details about the Object Lambda Access Point. See Configuration below for more details.
 * @property name The name for this Object Lambda Access Point.
 */
public data class ObjectLambdaAccessPointArgs(
    public val accountId: Output<String>? = null,
    public val configuration: Output<ObjectLambdaAccessPointConfigurationArgs>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3control.ObjectLambdaAccessPointArgs> {
    override fun toJava(): com.pulumi.aws.s3control.ObjectLambdaAccessPointArgs =
        com.pulumi.aws.s3control.ObjectLambdaAccessPointArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ObjectLambdaAccessPointArgs].
 */
@PulumiTagMarker
public class ObjectLambdaAccessPointArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var configuration: Output<ObjectLambdaAccessPointConfigurationArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value The AWS account ID for the owner of the bucket for which you want to create an Object Lambda Access Point. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("fyftcubuwiqbgatp")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value A configuration block containing details about the Object Lambda Access Point. See Configuration below for more details.
     */
    @JvmName("iioaivxclvofrxjj")
    public suspend fun configuration(`value`: Output<ObjectLambdaAccessPointConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value The name for this Object Lambda Access Point.
     */
    @JvmName("legjpuaccxbihnyd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The AWS account ID for the owner of the bucket for which you want to create an Object Lambda Access Point. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("jwmjpwmcqltccthn")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value A configuration block containing details about the Object Lambda Access Point. See Configuration below for more details.
     */
    @JvmName("blioerpmqomxyuev")
    public suspend fun configuration(`value`: ObjectLambdaAccessPointConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument A configuration block containing details about the Object Lambda Access Point. See Configuration below for more details.
     */
    @JvmName("sdqyocgykoffbens")
    public suspend fun configuration(argument: suspend ObjectLambdaAccessPointConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ObjectLambdaAccessPointConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value The name for this Object Lambda Access Point.
     */
    @JvmName("tjchamliwodxujhp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ObjectLambdaAccessPointArgs = ObjectLambdaAccessPointArgs(
        accountId = accountId,
        configuration = configuration,
        name = name,
    )
}
