@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ObjectLambdaAccessPointPolicy].
 */
@PulumiTagMarker
public class ObjectLambdaAccessPointPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ObjectLambdaAccessPointPolicyArgs = ObjectLambdaAccessPointPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ObjectLambdaAccessPointPolicyArgsBuilder.() -> Unit) {
        val builder = ObjectLambdaAccessPointPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ObjectLambdaAccessPointPolicy {
        val builtJavaResource =
            com.pulumi.aws.s3control.ObjectLambdaAccessPointPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ObjectLambdaAccessPointPolicy(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an S3 Object Lambda Access Point resource policy.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {bucket: "example"});
 * const exampleAccessPoint = new aws.s3.AccessPoint("example", {
 *     bucket: example.id,
 *     name: "example",
 * });
 * const exampleObjectLambdaAccessPoint = new aws.s3control.ObjectLambdaAccessPoint("example", {
 *     name: "example",
 *     configuration: {
 *         supportingAccessPoint: exampleAccessPoint.arn,
 *         transformationConfigurations: [{
 *             actions: ["GetObject"],
 *             contentTransformation: {
 *                 awsLambda: {
 *                     functionArn: exampleAwsLambdaFunction.arn,
 *                 },
 *             },
 *         }],
 *     },
 * });
 * const exampleObjectLambdaAccessPointPolicy = new aws.s3control.ObjectLambdaAccessPointPolicy("example", {
 *     name: exampleObjectLambdaAccessPoint.name,
 *     policy: pulumi.jsonStringify({
 *         Version: "2008-10-17",
 *         Statement: [{
 *             Effect: "Allow",
 *             Action: "s3-object-lambda:GetObject",
 *             Principal: {
 *                 AWS: current.accountId,
 *             },
 *             Resource: exampleObjectLambdaAccessPoint.arn,
 *         }],
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example", bucket="example")
 * example_access_point = aws.s3.AccessPoint("example",
 *     bucket=example.id,
 *     name="example")
 * example_object_lambda_access_point = aws.s3control.ObjectLambdaAccessPoint("example",
 *     name="example",
 *     configuration={
 *         "supporting_access_point": example_access_point.arn,
 *         "transformation_configurations": [{
 *             "actions": ["GetObject"],
 *             "content_transformation": {
 *                 "aws_lambda": {
 *                     "function_arn": example_aws_lambda_function["arn"],
 *                 },
 *             },
 *         }],
 *     })
 * example_object_lambda_access_point_policy = aws.s3control.ObjectLambdaAccessPointPolicy("example",
 *     name=example_object_lambda_access_point.name,
 *     policy=pulumi.Output.json_dumps({
 *         "Version": "2008-10-17",
 *         "Statement": [{
 *             "Effect": "Allow",
 *             "Action": "s3-object-lambda:GetObject",
 *             "Principal": {
 *                 "AWS": current["accountId"],
 *             },
 *             "Resource": example_object_lambda_access_point.arn,
 *         }],
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *     });
 *     var exampleAccessPoint = new Aws.S3.AccessPoint("example", new()
 *     {
 *         Bucket = example.Id,
 *         Name = "example",
 *     });
 *     var exampleObjectLambdaAccessPoint = new Aws.S3Control.ObjectLambdaAccessPoint("example", new()
 *     {
 *         Name = "example",
 *         Configuration = new Aws.S3Control.Inputs.ObjectLambdaAccessPointConfigurationArgs
 *         {
 *             SupportingAccessPoint = exampleAccessPoint.Arn,
 *             TransformationConfigurations = new[]
 *             {
 *                 new Aws.S3Control.Inputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs
 *                 {
 *                     Actions = new[]
 *                     {
 *                         "GetObject",
 *                     },
 *                     ContentTransformation = new Aws.S3Control.Inputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs
 *                     {
 *                         AwsLambda = new Aws.S3Control.Inputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs
 *                         {
 *                             FunctionArn = exampleAwsLambdaFunction.Arn,
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var exampleObjectLambdaAccessPointPolicy = new Aws.S3Control.ObjectLambdaAccessPointPolicy("example", new()
 *     {
 *         Name = exampleObjectLambdaAccessPoint.Name,
 *         Policy = Output.JsonSerialize(Output.Create(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2008-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Effect"] = "Allow",
 *                     ["Action"] = "s3-object-lambda:GetObject",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["AWS"] = current.AccountId,
 *                     },
 *                     ["Resource"] = exampleObjectLambdaAccessPoint.Arn,
 *                 },
 *             },
 *         })),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3control"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleAccessPoint, err := s3.NewAccessPoint(ctx, "example", &s3.AccessPointArgs{
 * 			Bucket: example.ID(),
 * 			Name:   pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleObjectLambdaAccessPoint, err := s3control.NewObjectLambdaAccessPoint(ctx, "example", &s3control.ObjectLambdaAccessPointArgs{
 * 			Name: pulumi.String("example"),
 * 			Configuration: &s3control.ObjectLambdaAccessPointConfigurationArgs{
 * 				SupportingAccessPoint: exampleAccessPoint.Arn,
 * 				TransformationConfigurations: s3control.ObjectLambdaAccessPointConfigurationTransformationConfigurationArray{
 * 					&s3control.ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs{
 * 						Actions: pulumi.StringArray{
 * 							pulumi.String("GetObject"),
 * 						},
 * 						ContentTransformation: &s3control.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs{
 * 							AwsLambda: &s3control.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs{
 * 								FunctionArn: pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3control.NewObjectLambdaAccessPointPolicy(ctx, "example", &s3control.ObjectLambdaAccessPointPolicyArgs{
 * 			Name: exampleObjectLambdaAccessPoint.Name,
 * 			Policy: exampleObjectLambdaAccessPoint.Arn.ApplyT(func(arn string) (pulumi.String, error) {
 * 				var _zero pulumi.String
 * 				tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 					"Version": "2008-10-17",
 * 					"Statement": []map[string]interface{}{
 * 						map[string]interface{}{
 * 							"Effect": "Allow",
 * 							"Action": "s3-object-lambda:GetObject",
 * 							"Principal": map[string]interface{}{
 * 								"AWS": current.AccountId,
 * 							},
 * 							"Resource": arn,
 * 						},
 * 					},
 * 				})
 * 				if err != nil {
 * 					return _zero, err
 * 				}
 * 				json0 := string(tmpJSON0)
 * 				return pulumi.String(json0), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.AccessPoint;
 * import com.pulumi.aws.s3.AccessPointArgs;
 * import com.pulumi.aws.s3control.ObjectLambdaAccessPoint;
 * import com.pulumi.aws.s3control.ObjectLambdaAccessPointArgs;
 * import com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationArgs;
 * import com.pulumi.aws.s3control.ObjectLambdaAccessPointPolicy;
 * import com.pulumi.aws.s3control.ObjectLambdaAccessPointPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("example")
 *             .build());
 *         var exampleAccessPoint = new AccessPoint("exampleAccessPoint", AccessPointArgs.builder()
 *             .bucket(example.id())
 *             .name("example")
 *             .build());
 *         var exampleObjectLambdaAccessPoint = new ObjectLambdaAccessPoint("exampleObjectLambdaAccessPoint", ObjectLambdaAccessPointArgs.builder()
 *             .name("example")
 *             .configuration(ObjectLambdaAccessPointConfigurationArgs.builder()
 *                 .supportingAccessPoint(exampleAccessPoint.arn())
 *                 .transformationConfigurations(ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs.builder()
 *                     .actions("GetObject")
 *                     .contentTransformation(ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs.builder()
 *                         .awsLambda(ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs.builder()
 *                             .functionArn(exampleAwsLambdaFunction.arn())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleObjectLambdaAccessPointPolicy = new ObjectLambdaAccessPointPolicy("exampleObjectLambdaAccessPointPolicy", ObjectLambdaAccessPointPolicyArgs.builder()
 *             .name(exampleObjectLambdaAccessPoint.name())
 *             .policy(exampleObjectLambdaAccessPoint.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2008-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Action", "s3-object-lambda:GetObject"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", current.accountId())
 *                         )),
 *                         jsonProperty("Resource", arn)
 *                     )))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example
 *   exampleAccessPoint:
 *     type: aws:s3:AccessPoint
 *     name: example
 *     properties:
 *       bucket: ${example.id}
 *       name: example
 *   exampleObjectLambdaAccessPoint:
 *     type: aws:s3control:ObjectLambdaAccessPoint
 *     name: example
 *     properties:
 *       name: example
 *       configuration:
 *         supportingAccessPoint: ${exampleAccessPoint.arn}
 *         transformationConfigurations:
 *           - actions:
 *               - GetObject
 *             contentTransformation:
 *               awsLambda:
 *                 functionArn: ${exampleAwsLambdaFunction.arn}
 *   exampleObjectLambdaAccessPointPolicy:
 *     type: aws:s3control:ObjectLambdaAccessPointPolicy
 *     name: example
 *     properties:
 *       name: ${exampleObjectLambdaAccessPoint.name}
 *       policy:
 *         fn::toJSON:
 *           Version: 2008-10-17
 *           Statement:
 *             - Effect: Allow
 *               Action: s3-object-lambda:GetObject
 *               Principal:
 *                 AWS: ${current.accountId}
 *               Resource: ${exampleObjectLambdaAccessPoint.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Object Lambda Access Point policies using the `account_id` and `name`, separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:s3control/objectLambdaAccessPointPolicy:ObjectLambdaAccessPointPolicy example 123456789012:example
 * ```
 */
public class ObjectLambdaAccessPointPolicy internal constructor(
    override val javaResource: com.pulumi.aws.s3control.ObjectLambdaAccessPointPolicy,
) : KotlinCustomResource(javaResource, ObjectLambdaAccessPointPolicyMapper) {
    /**
     * The AWS account ID for the account that owns the Object Lambda Access Point. Defaults to automatically determined account ID of the AWS provider.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * Indicates whether this access point currently has a policy that allows public access.
     */
    public val hasPublicAccessPolicy: Output<Boolean>
        get() = javaResource.hasPublicAccessPolicy().applyValue({ args0 -> args0 })

    /**
     * The name of the Object Lambda Access Point.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Object Lambda Access Point resource policy document.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object ObjectLambdaAccessPointPolicyMapper : ResourceMapper<ObjectLambdaAccessPointPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3control.ObjectLambdaAccessPointPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ObjectLambdaAccessPointPolicy =
        ObjectLambdaAccessPointPolicy(
            javaResource as
                com.pulumi.aws.s3control.ObjectLambdaAccessPointPolicy,
        )
}

/**
 * @see [ObjectLambdaAccessPointPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ObjectLambdaAccessPointPolicy].
 */
public suspend fun objectLambdaAccessPointPolicy(
    name: String,
    block: suspend ObjectLambdaAccessPointPolicyResourceBuilder.() -> Unit,
): ObjectLambdaAccessPointPolicy {
    val builder = ObjectLambdaAccessPointPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ObjectLambdaAccessPointPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun objectLambdaAccessPointPolicy(name: String): ObjectLambdaAccessPointPolicy {
    val builder = ObjectLambdaAccessPointPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
