@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfiguration
import com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [StorageLensConfiguration].
 */
@PulumiTagMarker
public class StorageLensConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StorageLensConfigurationArgs = StorageLensConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StorageLensConfigurationArgsBuilder.() -> Unit) {
        val builder = StorageLensConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StorageLensConfiguration {
        val builtJavaResource =
            com.pulumi.aws.s3control.StorageLensConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StorageLensConfiguration(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an S3 Storage Lens configuration.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const example = new aws.s3control.StorageLensConfiguration("example", {
 *     configId: "example-1",
 *     storageLensConfiguration: {
 *         enabled: true,
 *         accountLevel: {
 *             activityMetrics: {
 *                 enabled: true,
 *             },
 *             bucketLevel: {
 *                 activityMetrics: {
 *                     enabled: true,
 *                 },
 *             },
 *         },
 *         dataExport: {
 *             cloudWatchMetrics: {
 *                 enabled: true,
 *             },
 *             s3BucketDestination: {
 *                 accountId: current.then(current => current.accountId),
 *                 arn: target.arn,
 *                 format: "CSV",
 *                 outputSchemaVersion: "V_1",
 *                 encryption: {
 *                     sseS3s: [{}],
 *                 },
 *             },
 *         },
 *         exclude: {
 *             buckets: [
 *                 b1.arn,
 *                 b2.arn,
 *             ],
 *             regions: ["us-east-2"],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * example = aws.s3control.StorageLensConfiguration("example",
 *     config_id="example-1",
 *     storage_lens_configuration={
 *         "enabled": True,
 *         "account_level": {
 *             "activity_metrics": {
 *                 "enabled": True,
 *             },
 *             "bucket_level": {
 *                 "activity_metrics": {
 *                     "enabled": True,
 *                 },
 *             },
 *         },
 *         "data_export": {
 *             "cloud_watch_metrics": {
 *                 "enabled": True,
 *             },
 *             "s3_bucket_destination": {
 *                 "account_id": current.account_id,
 *                 "arn": target["arn"],
 *                 "format": "CSV",
 *                 "output_schema_version": "V_1",
 *                 "encryption": {
 *                     "sse_s3s": [{}],
 *                 },
 *             },
 *         },
 *         "exclude": {
 *             "buckets": [
 *                 b1["arn"],
 *                 b2["arn"],
 *             ],
 *             "regions": ["us-east-2"],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var example = new Aws.S3Control.StorageLensConfiguration("example", new()
 *     {
 *         ConfigId = "example-1",
 *         StorageLensConfigurationDetail = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationArgs
 *         {
 *             Enabled = true,
 *             AccountLevel = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelArgs
 *             {
 *                 ActivityMetrics = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetricsArgs
 *                 {
 *                     Enabled = true,
 *                 },
 *                 BucketLevel = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs
 *                 {
 *                     ActivityMetrics = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetricsArgs
 *                     {
 *                         Enabled = true,
 *                     },
 *                 },
 *             },
 *             DataExport = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationDataExportArgs
 *             {
 *                 CloudWatchMetrics = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs
 *                 {
 *                     Enabled = true,
 *                 },
 *                 S3BucketDestination = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs
 *                 {
 *                     AccountId = current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
 *                     Arn = target.Arn,
 *                     Format = "CSV",
 *                     OutputSchemaVersion = "V_1",
 *                     Encryption = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs
 *                     {
 *                         SseS3s = new[]
 *                         {
 *                             null,
 *                         },
 *                     },
 *                 },
 *             },
 *             Exclude = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationExcludeArgs
 *             {
 *                 Buckets = new[]
 *                 {
 *                     b1.Arn,
 *                     b2.Arn,
 *                 },
 *                 Regions = new[]
 *                 {
 *                     "us-east-2",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3control"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3control.NewStorageLensConfiguration(ctx, "example", &s3control.StorageLensConfigurationArgs{
 * 			ConfigId: pulumi.String("example-1"),
 * 			StorageLensConfiguration: &s3control.StorageLensConfigurationStorageLensConfigurationArgs{
 * 				Enabled: pulumi.Bool(true),
 * 				AccountLevel: &s3control.StorageLensConfigurationStorageLensConfigurationAccountLevelArgs{
 * 					ActivityMetrics: &s3control.StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetricsArgs{
 * 						Enabled: pulumi.Bool(true),
 * 					},
 * 					BucketLevel: &s3control.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs{
 * 						ActivityMetrics: &s3control.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetricsArgs{
 * 							Enabled: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				DataExport: &s3control.StorageLensConfigurationStorageLensConfigurationDataExportArgs{
 * 					CloudWatchMetrics: &s3control.StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs{
 * 						Enabled: pulumi.Bool(true),
 * 					},
 * 					S3BucketDestination: &s3control.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs{
 * 						AccountId:           pulumi.String(current.AccountId),
 * 						Arn:                 pulumi.Any(target.Arn),
 * 						Format:              pulumi.String("CSV"),
 * 						OutputSchemaVersion: pulumi.String("V_1"),
 * 						Encryption: &s3control.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs{
 * 							SseS3s: s3control.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3Array{
 * 								nil,
 * 							},
 * 						},
 * 					},
 * 				},
 * 				Exclude: &s3control.StorageLensConfigurationStorageLensConfigurationExcludeArgs{
 * 					Buckets: pulumi.StringArray{
 * 						b1.Arn,
 * 						b2.Arn,
 * 					},
 * 					Regions: pulumi.StringArray{
 * 						pulumi.String("us-east-2"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.s3control.StorageLensConfiguration;
 * import com.pulumi.aws.s3control.StorageLensConfigurationArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetricsArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetricsArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationExcludeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var example = new StorageLensConfiguration("example", StorageLensConfigurationArgs.builder()
 *             .configId("example-1")
 *             .storageLensConfiguration(StorageLensConfigurationStorageLensConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .accountLevel(StorageLensConfigurationStorageLensConfigurationAccountLevelArgs.builder()
 *                     .activityMetrics(StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetricsArgs.builder()
 *                         .enabled(true)
 *                         .build())
 *                     .bucketLevel(StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs.builder()
 *                         .activityMetrics(StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetricsArgs.builder()
 *                             .enabled(true)
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .dataExport(StorageLensConfigurationStorageLensConfigurationDataExportArgs.builder()
 *                     .cloudWatchMetrics(StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs.builder()
 *                         .enabled(true)
 *                         .build())
 *                     .s3BucketDestination(StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs.builder()
 *                         .accountId(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                         .arn(target.arn())
 *                         .format("CSV")
 *                         .outputSchemaVersion("V_1")
 *                         .encryption(StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs.builder()
 *                             .sseS3s()
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .exclude(StorageLensConfigurationStorageLensConfigurationExcludeArgs.builder()
 *                     .buckets(
 *                         b1.arn(),
 *                         b2.arn())
 *                     .regions("us-east-2")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3control:StorageLensConfiguration
 *     properties:
 *       configId: example-1
 *       storageLensConfiguration:
 *         enabled: true
 *         accountLevel:
 *           activityMetrics:
 *             enabled: true
 *           bucketLevel:
 *             activityMetrics:
 *               enabled: true
 *         dataExport:
 *           cloudWatchMetrics:
 *             enabled: true
 *           s3BucketDestination:
 *             accountId: ${current.accountId}
 *             arn: ${target.arn}
 *             format: CSV
 *             outputSchemaVersion: V_1
 *             encryption:
 *               sseS3s:
 *                 - {}
 *         exclude:
 *           buckets:
 *             - ${b1.arn}
 *             - ${b2.arn}
 *           regions:
 *             - us-east-2
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import S3 Storage Lens configurations using the `account_id` and `config_id`, separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:s3control/storageLensConfiguration:StorageLensConfiguration example 123456789012:example-1
 * ```
 */
public class StorageLensConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.s3control.StorageLensConfiguration,
) : KotlinCustomResource(javaResource, StorageLensConfigurationMapper) {
    /**
     * The AWS account ID for the S3 Storage Lens configuration. Defaults to automatically determined account ID of the AWS provider.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the S3 Storage Lens configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ID of the S3 Storage Lens configuration.
     */
    public val configId: Output<String>
        get() = javaResource.configId().applyValue({ args0 -> args0 })

    /**
     * The S3 Storage Lens configuration. See Storage Lens Configuration below for more details.
     */
    public val storageLensConfiguration: Output<StorageLensConfigurationStorageLensConfiguration>
        get() = javaResource.storageLensConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object StorageLensConfigurationMapper : ResourceMapper<StorageLensConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3control.StorageLensConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): StorageLensConfiguration =
        StorageLensConfiguration(javaResource as com.pulumi.aws.s3control.StorageLensConfiguration)
}

/**
 * @see [StorageLensConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StorageLensConfiguration].
 */
public suspend fun storageLensConfiguration(
    name: String,
    block: suspend StorageLensConfigurationResourceBuilder.() -> Unit,
): StorageLensConfiguration {
    val builder = StorageLensConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StorageLensConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun storageLensConfiguration(name: String): StorageLensConfiguration {
    val builder = StorageLensConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
