@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.StorageLensConfigurationArgs.builder
import com.pulumi.aws.s3control.kotlin.inputs.StorageLensConfigurationStorageLensConfigurationArgs
import com.pulumi.aws.s3control.kotlin.inputs.StorageLensConfigurationStorageLensConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an S3 Storage Lens configuration.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const example = new aws.s3control.StorageLensConfiguration("example", {
 *     configId: "example-1",
 *     storageLensConfiguration: {
 *         enabled: true,
 *         accountLevel: {
 *             activityMetrics: {
 *                 enabled: true,
 *             },
 *             bucketLevel: {
 *                 activityMetrics: {
 *                     enabled: true,
 *                 },
 *             },
 *         },
 *         dataExport: {
 *             cloudWatchMetrics: {
 *                 enabled: true,
 *             },
 *             s3BucketDestination: {
 *                 accountId: current.then(current => current.accountId),
 *                 arn: target.arn,
 *                 format: "CSV",
 *                 outputSchemaVersion: "V_1",
 *                 encryption: {
 *                     sseS3s: [{}],
 *                 },
 *             },
 *         },
 *         exclude: {
 *             buckets: [
 *                 b1.arn,
 *                 b2.arn,
 *             ],
 *             regions: ["us-east-2"],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * example = aws.s3control.StorageLensConfiguration("example",
 *     config_id="example-1",
 *     storage_lens_configuration={
 *         "enabled": True,
 *         "account_level": {
 *             "activity_metrics": {
 *                 "enabled": True,
 *             },
 *             "bucket_level": {
 *                 "activity_metrics": {
 *                     "enabled": True,
 *                 },
 *             },
 *         },
 *         "data_export": {
 *             "cloud_watch_metrics": {
 *                 "enabled": True,
 *             },
 *             "s3_bucket_destination": {
 *                 "account_id": current.account_id,
 *                 "arn": target["arn"],
 *                 "format": "CSV",
 *                 "output_schema_version": "V_1",
 *                 "encryption": {
 *                     "sse_s3s": [{}],
 *                 },
 *             },
 *         },
 *         "exclude": {
 *             "buckets": [
 *                 b1["arn"],
 *                 b2["arn"],
 *             ],
 *             "regions": ["us-east-2"],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var example = new Aws.S3Control.StorageLensConfiguration("example", new()
 *     {
 *         ConfigId = "example-1",
 *         StorageLensConfigurationDetail = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationArgs
 *         {
 *             Enabled = true,
 *             AccountLevel = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelArgs
 *             {
 *                 ActivityMetrics = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetricsArgs
 *                 {
 *                     Enabled = true,
 *                 },
 *                 BucketLevel = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs
 *                 {
 *                     ActivityMetrics = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetricsArgs
 *                     {
 *                         Enabled = true,
 *                     },
 *                 },
 *             },
 *             DataExport = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationDataExportArgs
 *             {
 *                 CloudWatchMetrics = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs
 *                 {
 *                     Enabled = true,
 *                 },
 *                 S3BucketDestination = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs
 *                 {
 *                     AccountId = current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
 *                     Arn = target.Arn,
 *                     Format = "CSV",
 *                     OutputSchemaVersion = "V_1",
 *                     Encryption = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs
 *                     {
 *                         SseS3s = new[]
 *                         {
 *                             null,
 *                         },
 *                     },
 *                 },
 *             },
 *             Exclude = new Aws.S3Control.Inputs.StorageLensConfigurationStorageLensConfigurationExcludeArgs
 *             {
 *                 Buckets = new[]
 *                 {
 *                     b1.Arn,
 *                     b2.Arn,
 *                 },
 *                 Regions = new[]
 *                 {
 *                     "us-east-2",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3control"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3control.NewStorageLensConfiguration(ctx, "example", &s3control.StorageLensConfigurationArgs{
 * 			ConfigId: pulumi.String("example-1"),
 * 			StorageLensConfiguration: &s3control.StorageLensConfigurationStorageLensConfigurationArgs{
 * 				Enabled: pulumi.Bool(true),
 * 				AccountLevel: &s3control.StorageLensConfigurationStorageLensConfigurationAccountLevelArgs{
 * 					ActivityMetrics: &s3control.StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetricsArgs{
 * 						Enabled: pulumi.Bool(true),
 * 					},
 * 					BucketLevel: &s3control.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs{
 * 						ActivityMetrics: &s3control.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetricsArgs{
 * 							Enabled: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 				DataExport: &s3control.StorageLensConfigurationStorageLensConfigurationDataExportArgs{
 * 					CloudWatchMetrics: &s3control.StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs{
 * 						Enabled: pulumi.Bool(true),
 * 					},
 * 					S3BucketDestination: &s3control.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs{
 * 						AccountId:           pulumi.String(current.AccountId),
 * 						Arn:                 pulumi.Any(target.Arn),
 * 						Format:              pulumi.String("CSV"),
 * 						OutputSchemaVersion: pulumi.String("V_1"),
 * 						Encryption: &s3control.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs{
 * 							SseS3s: s3control.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3Array{
 * 								nil,
 * 							},
 * 						},
 * 					},
 * 				},
 * 				Exclude: &s3control.StorageLensConfigurationStorageLensConfigurationExcludeArgs{
 * 					Buckets: pulumi.StringArray{
 * 						b1.Arn,
 * 						b2.Arn,
 * 					},
 * 					Regions: pulumi.StringArray{
 * 						pulumi.String("us-east-2"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.s3control.StorageLensConfiguration;
 * import com.pulumi.aws.s3control.StorageLensConfigurationArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetricsArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetricsArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationExcludeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var example = new StorageLensConfiguration("example", StorageLensConfigurationArgs.builder()
 *             .configId("example-1")
 *             .storageLensConfiguration(StorageLensConfigurationStorageLensConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .accountLevel(StorageLensConfigurationStorageLensConfigurationAccountLevelArgs.builder()
 *                     .activityMetrics(StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetricsArgs.builder()
 *                         .enabled(true)
 *                         .build())
 *                     .bucketLevel(StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs.builder()
 *                         .activityMetrics(StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetricsArgs.builder()
 *                             .enabled(true)
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .dataExport(StorageLensConfigurationStorageLensConfigurationDataExportArgs.builder()
 *                     .cloudWatchMetrics(StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs.builder()
 *                         .enabled(true)
 *                         .build())
 *                     .s3BucketDestination(StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs.builder()
 *                         .accountId(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                         .arn(target.arn())
 *                         .format("CSV")
 *                         .outputSchemaVersion("V_1")
 *                         .encryption(StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs.builder()
 *                             .sseS3s()
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .exclude(StorageLensConfigurationStorageLensConfigurationExcludeArgs.builder()
 *                     .buckets(
 *                         b1.arn(),
 *                         b2.arn())
 *                     .regions("us-east-2")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3control:StorageLensConfiguration
 *     properties:
 *       configId: example-1
 *       storageLensConfiguration:
 *         enabled: true
 *         accountLevel:
 *           activityMetrics:
 *             enabled: true
 *           bucketLevel:
 *             activityMetrics:
 *               enabled: true
 *         dataExport:
 *           cloudWatchMetrics:
 *             enabled: true
 *           s3BucketDestination:
 *             accountId: ${current.accountId}
 *             arn: ${target.arn}
 *             format: CSV
 *             outputSchemaVersion: V_1
 *             encryption:
 *               sseS3s:
 *                 - {}
 *         exclude:
 *           buckets:
 *             - ${b1.arn}
 *             - ${b2.arn}
 *           regions:
 *             - us-east-2
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import S3 Storage Lens configurations using the `account_id` and `config_id`, separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:s3control/storageLensConfiguration:StorageLensConfiguration example 123456789012:example-1
 * ```
 * @property accountId The AWS account ID for the S3 Storage Lens configuration. Defaults to automatically determined account ID of the AWS provider.
 * @property configId The ID of the S3 Storage Lens configuration.
 * @property storageLensConfiguration The S3 Storage Lens configuration. See Storage Lens Configuration below for more details.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class StorageLensConfigurationArgs(
    public val accountId: Output<String>? = null,
    public val configId: Output<String>? = null,
    public val storageLensConfiguration: Output<StorageLensConfigurationStorageLensConfigurationArgs>? =
        null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3control.StorageLensConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3control.StorageLensConfigurationArgs =
        com.pulumi.aws.s3control.StorageLensConfigurationArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .configId(configId?.applyValue({ args0 -> args0 }))
            .storageLensConfiguration(
                storageLensConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StorageLensConfigurationArgs].
 */
@PulumiTagMarker
public class StorageLensConfigurationArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var configId: Output<String>? = null

    private var storageLensConfiguration:
        Output<StorageLensConfigurationStorageLensConfigurationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The AWS account ID for the S3 Storage Lens configuration. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("oahufcwryvfwnhpu")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The ID of the S3 Storage Lens configuration.
     */
    @JvmName("urjbdawyoxywxdgq")
    public suspend fun configId(`value`: Output<String>) {
        this.configId = value
    }

    /**
     * @param value The S3 Storage Lens configuration. See Storage Lens Configuration below for more details.
     */
    @JvmName("kgjnwersbxsjictg")
    public suspend fun storageLensConfiguration(`value`: Output<StorageLensConfigurationStorageLensConfigurationArgs>) {
        this.storageLensConfiguration = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rgtxbawfkguvwqem")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The AWS account ID for the S3 Storage Lens configuration. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("whnbsurirecnfuxe")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The ID of the S3 Storage Lens configuration.
     */
    @JvmName("kfbljkosswhwfcpr")
    public suspend fun configId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configId = mapped
    }

    /**
     * @param value The S3 Storage Lens configuration. See Storage Lens Configuration below for more details.
     */
    @JvmName("hdhghyolyffaoddj")
    public suspend fun storageLensConfiguration(`value`: StorageLensConfigurationStorageLensConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageLensConfiguration = mapped
    }

    /**
     * @param argument The S3 Storage Lens configuration. See Storage Lens Configuration below for more details.
     */
    @JvmName("kqxkdqahvtjhdity")
    public suspend fun storageLensConfiguration(argument: suspend StorageLensConfigurationStorageLensConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = StorageLensConfigurationStorageLensConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.storageLensConfiguration = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ckhnrxkepncnufts")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hgsgqiwporycwkal")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): StorageLensConfigurationArgs = StorageLensConfigurationArgs(
        accountId = accountId,
        configId = configId,
        storageLensConfiguration = storageLensConfiguration,
        tags = tags,
    )
}
