@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.AccessGrantAccessGrantsLocationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property s3SubPrefix Sub-prefix.
 */
public data class AccessGrantAccessGrantsLocationConfigurationArgs(
    public val s3SubPrefix: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.s3control.inputs.AccessGrantAccessGrantsLocationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.AccessGrantAccessGrantsLocationConfigurationArgs =
        com.pulumi.aws.s3control.inputs.AccessGrantAccessGrantsLocationConfigurationArgs.builder()
            .s3SubPrefix(s3SubPrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessGrantAccessGrantsLocationConfigurationArgs].
 */
@PulumiTagMarker
public class AccessGrantAccessGrantsLocationConfigurationArgsBuilder internal constructor() {
    private var s3SubPrefix: Output<String>? = null

    /**
     * @param value Sub-prefix.
     */
    @JvmName("fcknrlhnwbbbvkrb")
    public suspend fun s3SubPrefix(`value`: Output<String>) {
        this.s3SubPrefix = value
    }

    /**
     * @param value Sub-prefix.
     */
    @JvmName("jqjaaegnlmpufijl")
    public suspend fun s3SubPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3SubPrefix = mapped
    }

    internal fun build(): AccessGrantAccessGrantsLocationConfigurationArgs =
        AccessGrantAccessGrantsLocationConfigurationArgs(
            s3SubPrefix = s3SubPrefix,
        )
}
