@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.AccessGrantGranteeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property granteeIdentifier Grantee identifier.
 * @property granteeType Grantee types. Valid values: `DIRECTORY_USER`, `DIRECTORY_GROUP`, `IAM`.
 */
public data class AccessGrantGranteeArgs(
    public val granteeIdentifier: Output<String>,
    public val granteeType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3control.inputs.AccessGrantGranteeArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.AccessGrantGranteeArgs =
        com.pulumi.aws.s3control.inputs.AccessGrantGranteeArgs.builder()
            .granteeIdentifier(granteeIdentifier.applyValue({ args0 -> args0 }))
            .granteeType(granteeType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessGrantGranteeArgs].
 */
@PulumiTagMarker
public class AccessGrantGranteeArgsBuilder internal constructor() {
    private var granteeIdentifier: Output<String>? = null

    private var granteeType: Output<String>? = null

    /**
     * @param value Grantee identifier.
     */
    @JvmName("hyfwhaceuyjohyao")
    public suspend fun granteeIdentifier(`value`: Output<String>) {
        this.granteeIdentifier = value
    }

    /**
     * @param value Grantee types. Valid values: `DIRECTORY_USER`, `DIRECTORY_GROUP`, `IAM`.
     */
    @JvmName("ggvtarofgfaoaxmn")
    public suspend fun granteeType(`value`: Output<String>) {
        this.granteeType = value
    }

    /**
     * @param value Grantee identifier.
     */
    @JvmName("xtuhbxnmqryxqxpf")
    public suspend fun granteeIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.granteeIdentifier = mapped
    }

    /**
     * @param value Grantee types. Valid values: `DIRECTORY_USER`, `DIRECTORY_GROUP`, `IAM`.
     */
    @JvmName("wlwnqkxcoltwgahn")
    public suspend fun granteeType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.granteeType = mapped
    }

    internal fun build(): AccessGrantGranteeArgs = AccessGrantGranteeArgs(
        granteeIdentifier = granteeIdentifier ?: throw PulumiNullFieldException("granteeIdentifier"),
        granteeType = granteeType ?: throw PulumiNullFieldException("granteeType"),
    )
}
