@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property abortIncompleteMultipartUpload Configuration block containing settings for abort incomplete multipart upload.
 * @property expiration Configuration block containing settings for expiration of objects.
 * @property filter Configuration block containing settings for filtering.
 * @property id Unique identifier for the rule.
 * @property status Status of the rule. Valid values: `Enabled` and `Disabled`. Defaults to `Enabled`.
 */
public data class BucketLifecycleConfigurationRuleArgs(
    public val abortIncompleteMultipartUpload: Output<BucketLifecycleConfigurationRuleAbortIncompleteMultipartUploadArgs>? = null,
    public val expiration: Output<BucketLifecycleConfigurationRuleExpirationArgs>? = null,
    public val filter: Output<BucketLifecycleConfigurationRuleFilterArgs>? = null,
    public val id: Output<String>,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleArgs =
        com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleArgs.builder()
            .abortIncompleteMultipartUpload(
                abortIncompleteMultipartUpload?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .expiration(expiration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLifecycleConfigurationRuleArgs].
 */
@PulumiTagMarker
public class BucketLifecycleConfigurationRuleArgsBuilder internal constructor() {
    private var abortIncompleteMultipartUpload:
        Output<BucketLifecycleConfigurationRuleAbortIncompleteMultipartUploadArgs>? = null

    private var expiration: Output<BucketLifecycleConfigurationRuleExpirationArgs>? = null

    private var filter: Output<BucketLifecycleConfigurationRuleFilterArgs>? = null

    private var id: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value Configuration block containing settings for abort incomplete multipart upload.
     */
    @JvmName("konldjxprbqwopgh")
    public suspend fun abortIncompleteMultipartUpload(`value`: Output<BucketLifecycleConfigurationRuleAbortIncompleteMultipartUploadArgs>) {
        this.abortIncompleteMultipartUpload = value
    }

    /**
     * @param value Configuration block containing settings for expiration of objects.
     */
    @JvmName("pgvwlgxxxnlaxywt")
    public suspend fun expiration(`value`: Output<BucketLifecycleConfigurationRuleExpirationArgs>) {
        this.expiration = value
    }

    /**
     * @param value Configuration block containing settings for filtering.
     */
    @JvmName("yfmbbwagemkftcib")
    public suspend fun filter(`value`: Output<BucketLifecycleConfigurationRuleFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value Unique identifier for the rule.
     */
    @JvmName("fdvvqlquyklqbdyx")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Status of the rule. Valid values: `Enabled` and `Disabled`. Defaults to `Enabled`.
     */
    @JvmName("wppmkroswsynvwug")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Configuration block containing settings for abort incomplete multipart upload.
     */
    @JvmName("coyxsftagceupfvx")
    public suspend fun abortIncompleteMultipartUpload(`value`: BucketLifecycleConfigurationRuleAbortIncompleteMultipartUploadArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.abortIncompleteMultipartUpload = mapped
    }

    /**
     * @param argument Configuration block containing settings for abort incomplete multipart upload.
     */
    @JvmName("bsrcqfajhdlsskuv")
    public suspend fun abortIncompleteMultipartUpload(argument: suspend BucketLifecycleConfigurationRuleAbortIncompleteMultipartUploadArgsBuilder.() -> Unit) {
        val toBeMapped =
            BucketLifecycleConfigurationRuleAbortIncompleteMultipartUploadArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.abortIncompleteMultipartUpload = mapped
    }

    /**
     * @param value Configuration block containing settings for expiration of objects.
     */
    @JvmName("htykegclsefktbur")
    public suspend fun expiration(`value`: BucketLifecycleConfigurationRuleExpirationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiration = mapped
    }

    /**
     * @param argument Configuration block containing settings for expiration of objects.
     */
    @JvmName("trsoyusdmujqfjee")
    public suspend fun expiration(argument: suspend BucketLifecycleConfigurationRuleExpirationArgsBuilder.() -> Unit) {
        val toBeMapped = BucketLifecycleConfigurationRuleExpirationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.expiration = mapped
    }

    /**
     * @param value Configuration block containing settings for filtering.
     */
    @JvmName("hqccugvidfqnscfr")
    public suspend fun filter(`value`: BucketLifecycleConfigurationRuleFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Configuration block containing settings for filtering.
     */
    @JvmName("vyxslannshmyjcek")
    public suspend fun filter(argument: suspend BucketLifecycleConfigurationRuleFilterArgsBuilder.() -> Unit) {
        val toBeMapped = BucketLifecycleConfigurationRuleFilterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value Unique identifier for the rule.
     */
    @JvmName("cjeajgeyghawmjaw")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Status of the rule. Valid values: `Enabled` and `Disabled`. Defaults to `Enabled`.
     */
    @JvmName("lejrjxthortignrl")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): BucketLifecycleConfigurationRuleArgs = BucketLifecycleConfigurationRuleArgs(
        abortIncompleteMultipartUpload = abortIncompleteMultipartUpload,
        expiration = expiration,
        filter = filter,
        id = id ?: throw PulumiNullFieldException("id"),
        status = status,
    )
}
