@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleExpirationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property date Date the object is to be deleted. Should be in `YYYY-MM-DD` date format, e.g., `2020-09-30`.
 * @property days Number of days before the object is to be deleted.
 * @property expiredObjectDeleteMarker Enable to remove a delete marker with no noncurrent versions. Cannot be specified with `date` or `days`.
 */
public data class BucketLifecycleConfigurationRuleExpirationArgs(
    public val date: Output<String>? = null,
    public val days: Output<Int>? = null,
    public val expiredObjectDeleteMarker: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleExpirationArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleExpirationArgs =
        com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleExpirationArgs.builder()
            .date(date?.applyValue({ args0 -> args0 }))
            .days(days?.applyValue({ args0 -> args0 }))
            .expiredObjectDeleteMarker(expiredObjectDeleteMarker?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLifecycleConfigurationRuleExpirationArgs].
 */
@PulumiTagMarker
public class BucketLifecycleConfigurationRuleExpirationArgsBuilder internal constructor() {
    private var date: Output<String>? = null

    private var days: Output<Int>? = null

    private var expiredObjectDeleteMarker: Output<Boolean>? = null

    /**
     * @param value Date the object is to be deleted. Should be in `YYYY-MM-DD` date format, e.g., `2020-09-30`.
     */
    @JvmName("byntsskqbogelwvq")
    public suspend fun date(`value`: Output<String>) {
        this.date = value
    }

    /**
     * @param value Number of days before the object is to be deleted.
     */
    @JvmName("pqilixawfhaaltjm")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value Enable to remove a delete marker with no noncurrent versions. Cannot be specified with `date` or `days`.
     */
    @JvmName("dpehajvxpghwwrll")
    public suspend fun expiredObjectDeleteMarker(`value`: Output<Boolean>) {
        this.expiredObjectDeleteMarker = value
    }

    /**
     * @param value Date the object is to be deleted. Should be in `YYYY-MM-DD` date format, e.g., `2020-09-30`.
     */
    @JvmName("wruthdihcgdebwkd")
    public suspend fun date(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.date = mapped
    }

    /**
     * @param value Number of days before the object is to be deleted.
     */
    @JvmName("sunepdphfqplmfgg")
    public suspend fun days(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value Enable to remove a delete marker with no noncurrent versions. Cannot be specified with `date` or `days`.
     */
    @JvmName("gvavmlerklegilqq")
    public suspend fun expiredObjectDeleteMarker(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiredObjectDeleteMarker = mapped
    }

    internal fun build(): BucketLifecycleConfigurationRuleExpirationArgs =
        BucketLifecycleConfigurationRuleExpirationArgs(
            date = date,
            days = days,
            expiredObjectDeleteMarker = expiredObjectDeleteMarker,
        )
}
