@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property prefix Object prefix for rule filtering.
 * @property tags Key-value map of object tags for rule filtering.
 */
public data class BucketLifecycleConfigurationRuleFilterArgs(
    public val prefix: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleFilterArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleFilterArgs = com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleFilterArgs.builder()
        .prefix(prefix?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [BucketLifecycleConfigurationRuleFilterArgs].
 */
@PulumiTagMarker
public class BucketLifecycleConfigurationRuleFilterArgsBuilder internal constructor() {
    private var prefix: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Object prefix for rule filtering.
     */
    @JvmName("bywcwnbugmnkqebg")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Key-value map of object tags for rule filtering.
     */
    @JvmName("sivnatvyebfuvmot")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Object prefix for rule filtering.
     */
    @JvmName("mdmvvcxubasfqqgx")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Key-value map of object tags for rule filtering.
     */
    @JvmName("ctxtxfinyfyusomy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of object tags for rule filtering.
     */
    @JvmName("wbmyjhechqajprrq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BucketLifecycleConfigurationRuleFilterArgs =
        BucketLifecycleConfigurationRuleFilterArgs(
            prefix = prefix,
            tags = tags,
        )
}
