@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.MultiRegionAccessPointDetailsRegionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket
 * @property bucketAccountId
 * @property region
 */
public data class MultiRegionAccessPointDetailsRegionArgs(
    public val bucket: Output<String>,
    public val bucketAccountId: Output<String>? = null,
    public val region: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3control.inputs.MultiRegionAccessPointDetailsRegionArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.MultiRegionAccessPointDetailsRegionArgs =
        com.pulumi.aws.s3control.inputs.MultiRegionAccessPointDetailsRegionArgs.builder()
            .bucket(bucket.applyValue({ args0 -> args0 }))
            .bucketAccountId(bucketAccountId?.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MultiRegionAccessPointDetailsRegionArgs].
 */
@PulumiTagMarker
public class MultiRegionAccessPointDetailsRegionArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var bucketAccountId: Output<String>? = null

    private var region: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("pflvxdlrildophyh")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value
     */
    @JvmName("qlnyygrpjwpkyoxu")
    public suspend fun bucketAccountId(`value`: Output<String>) {
        this.bucketAccountId = value
    }

    /**
     * @param value
     */
    @JvmName("hjiqjvbujxsooqev")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value
     */
    @JvmName("crunjfqpupksfgqe")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value
     */
    @JvmName("waojuxijgpqbhqxo")
    public suspend fun bucketAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketAccountId = mapped
    }

    /**
     * @param value
     */
    @JvmName("vrppbpwkppithglc")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    internal fun build(): MultiRegionAccessPointDetailsRegionArgs =
        MultiRegionAccessPointDetailsRegionArgs(
            bucket = bucket ?: throw PulumiNullFieldException("bucket"),
            bucketAccountId = bucketAccountId,
            region = region,
        )
}
