@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowedFeatures Allowed features. Valid values: `GetObject-Range`, `GetObject-PartNumber`.
 * @property cloudWatchMetricsEnabled Whether or not the CloudWatch metrics configuration is enabled.
 * @property supportingAccessPoint Standard access point associated with the Object Lambda Access Point.
 * @property transformationConfigurations List of transformation configurations for the Object Lambda Access Point. See Transformation Configuration below for more details.
 */
public data class ObjectLambdaAccessPointConfigurationArgs(
    public val allowedFeatures: Output<List<String>>? = null,
    public val cloudWatchMetricsEnabled: Output<Boolean>? = null,
    public val supportingAccessPoint: Output<String>,
    public val transformationConfigurations: Output<List<ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs>>,
) : ConvertibleToJava<com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationArgs =
        com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationArgs.builder()
            .allowedFeatures(allowedFeatures?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cloudWatchMetricsEnabled(cloudWatchMetricsEnabled?.applyValue({ args0 -> args0 }))
            .supportingAccessPoint(supportingAccessPoint.applyValue({ args0 -> args0 }))
            .transformationConfigurations(
                transformationConfigurations.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [ObjectLambdaAccessPointConfigurationArgs].
 */
@PulumiTagMarker
public class ObjectLambdaAccessPointConfigurationArgsBuilder internal constructor() {
    private var allowedFeatures: Output<List<String>>? = null

    private var cloudWatchMetricsEnabled: Output<Boolean>? = null

    private var supportingAccessPoint: Output<String>? = null

    private var transformationConfigurations:
        Output<List<ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs>>? = null

    /**
     * @param value Allowed features. Valid values: `GetObject-Range`, `GetObject-PartNumber`.
     */
    @JvmName("edyywtkmuvquymkn")
    public suspend fun allowedFeatures(`value`: Output<List<String>>) {
        this.allowedFeatures = value
    }

    @JvmName("iytaufqrdhwupboc")
    public suspend fun allowedFeatures(vararg values: Output<String>) {
        this.allowedFeatures = Output.all(values.asList())
    }

    /**
     * @param values Allowed features. Valid values: `GetObject-Range`, `GetObject-PartNumber`.
     */
    @JvmName("hyauppihitmhuvcl")
    public suspend fun allowedFeatures(values: List<Output<String>>) {
        this.allowedFeatures = Output.all(values)
    }

    /**
     * @param value Whether or not the CloudWatch metrics configuration is enabled.
     */
    @JvmName("enbiasldctxtykuc")
    public suspend fun cloudWatchMetricsEnabled(`value`: Output<Boolean>) {
        this.cloudWatchMetricsEnabled = value
    }

    /**
     * @param value Standard access point associated with the Object Lambda Access Point.
     */
    @JvmName("jjsggolydkrbckxn")
    public suspend fun supportingAccessPoint(`value`: Output<String>) {
        this.supportingAccessPoint = value
    }

    /**
     * @param value List of transformation configurations for the Object Lambda Access Point. See Transformation Configuration below for more details.
     */
    @JvmName("yjsmwbnmourakvfo")
    public suspend fun transformationConfigurations(`value`: Output<List<ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs>>) {
        this.transformationConfigurations = value
    }

    @JvmName("vsyxeunpyjfvblmr")
    public suspend fun transformationConfigurations(vararg values: Output<ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs>) {
        this.transformationConfigurations = Output.all(values.asList())
    }

    /**
     * @param values List of transformation configurations for the Object Lambda Access Point. See Transformation Configuration below for more details.
     */
    @JvmName("nhvniolwggfxvhix")
    public suspend fun transformationConfigurations(values: List<Output<ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs>>) {
        this.transformationConfigurations = Output.all(values)
    }

    /**
     * @param value Allowed features. Valid values: `GetObject-Range`, `GetObject-PartNumber`.
     */
    @JvmName("bfqvbuewmygketny")
    public suspend fun allowedFeatures(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedFeatures = mapped
    }

    /**
     * @param values Allowed features. Valid values: `GetObject-Range`, `GetObject-PartNumber`.
     */
    @JvmName("blgrrsdhlsahonmo")
    public suspend fun allowedFeatures(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedFeatures = mapped
    }

    /**
     * @param value Whether or not the CloudWatch metrics configuration is enabled.
     */
    @JvmName("ruwnwqsyvikxbvbq")
    public suspend fun cloudWatchMetricsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudWatchMetricsEnabled = mapped
    }

    /**
     * @param value Standard access point associated with the Object Lambda Access Point.
     */
    @JvmName("mmrxmxqlhkksnovi")
    public suspend fun supportingAccessPoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportingAccessPoint = mapped
    }

    /**
     * @param value List of transformation configurations for the Object Lambda Access Point. See Transformation Configuration below for more details.
     */
    @JvmName("rjffteppmemrkatj")
    public suspend fun transformationConfigurations(`value`: List<ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transformationConfigurations = mapped
    }

    /**
     * @param argument List of transformation configurations for the Object Lambda Access Point. See Transformation Configuration below for more details.
     */
    @JvmName("aejnoxbjwateggkf")
    public suspend fun transformationConfigurations(argument: List<suspend ObjectLambdaAccessPointConfigurationTransformationConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ObjectLambdaAccessPointConfigurationTransformationConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.transformationConfigurations = mapped
    }

    /**
     * @param argument List of transformation configurations for the Object Lambda Access Point. See Transformation Configuration below for more details.
     */
    @JvmName("lghquhochittaivp")
    public suspend fun transformationConfigurations(vararg argument: suspend ObjectLambdaAccessPointConfigurationTransformationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ObjectLambdaAccessPointConfigurationTransformationConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.transformationConfigurations = mapped
    }

    /**
     * @param argument List of transformation configurations for the Object Lambda Access Point. See Transformation Configuration below for more details.
     */
    @JvmName("upkodtgfkrijihhi")
    public suspend fun transformationConfigurations(argument: suspend ObjectLambdaAccessPointConfigurationTransformationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ObjectLambdaAccessPointConfigurationTransformationConfigurationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.transformationConfigurations = mapped
    }

    /**
     * @param values List of transformation configurations for the Object Lambda Access Point. See Transformation Configuration below for more details.
     */
    @JvmName("jqudvdpepublnysm")
    public suspend fun transformationConfigurations(vararg values: ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transformationConfigurations = mapped
    }

    internal fun build(): ObjectLambdaAccessPointConfigurationArgs =
        ObjectLambdaAccessPointConfigurationArgs(
            allowedFeatures = allowedFeatures,
            cloudWatchMetricsEnabled = cloudWatchMetricsEnabled,
            supportingAccessPoint = supportingAccessPoint ?: throw
                PulumiNullFieldException("supportingAccessPoint"),
            transformationConfigurations = transformationConfigurations ?: throw
                PulumiNullFieldException("transformationConfigurations"),
        )
}
