@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property actions The actions of an Object Lambda Access Point configuration. Valid values: `GetObject`.
 * @property contentTransformation The content transformation of an Object Lambda Access Point configuration. See Content Transformation below for more details.
 */
public data class ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs(
    public val actions: Output<List<String>>,
    public val contentTransformation: Output<ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs =
        com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs.builder()
            .actions(actions.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .contentTransformation(
                contentTransformation.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs].
 */
@PulumiTagMarker
public class ObjectLambdaAccessPointConfigurationTransformationConfigurationArgsBuilder internal constructor() {
    private var actions: Output<List<String>>? = null

    private var contentTransformation:
        Output<ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs>? =
        null

    /**
     * @param value The actions of an Object Lambda Access Point configuration. Valid values: `GetObject`.
     */
    @JvmName("lmwqbbrbsodacnvm")
    public suspend fun actions(`value`: Output<List<String>>) {
        this.actions = value
    }

    @JvmName("tnybdknnlkufqvrg")
    public suspend fun actions(vararg values: Output<String>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values The actions of an Object Lambda Access Point configuration. Valid values: `GetObject`.
     */
    @JvmName("fnjvxmpnecbtlwlt")
    public suspend fun actions(values: List<Output<String>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value The content transformation of an Object Lambda Access Point configuration. See Content Transformation below for more details.
     */
    @JvmName("xofaeiefhkmafhno")
    public suspend fun contentTransformation(`value`: Output<ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs>) {
        this.contentTransformation = value
    }

    /**
     * @param value The actions of an Object Lambda Access Point configuration. Valid values: `GetObject`.
     */
    @JvmName("mhmgjbtexudggjmt")
    public suspend fun actions(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param values The actions of an Object Lambda Access Point configuration. Valid values: `GetObject`.
     */
    @JvmName("geibmwmixvodjhid")
    public suspend fun actions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value The content transformation of an Object Lambda Access Point configuration. See Content Transformation below for more details.
     */
    @JvmName("vtwfbbucijcifmrp")
    public suspend fun contentTransformation(`value`: ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentTransformation = mapped
    }

    /**
     * @param argument The content transformation of an Object Lambda Access Point configuration. See Content Transformation below for more details.
     */
    @JvmName("ihempeykmhxlnlxc")
    public suspend fun contentTransformation(argument: suspend ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.contentTransformation = mapped
    }

    internal fun build(): ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs =
        ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs(
            actions = actions ?: throw PulumiNullFieldException("actions"),
            contentTransformation = contentTransformation ?: throw
                PulumiNullFieldException("contentTransformation"),
        )
}
