@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property awsLambda Configuration for an AWS Lambda function. See AWS Lambda below for more details.
 */
public data class
ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs(
    public val awsLambda: Output<ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs =
        com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs.builder()
            .awsLambda(awsLambda.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs].
 */
@PulumiTagMarker
public class
ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgsBuilder
internal constructor() {
    private var awsLambda:
        Output<ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs>? =
        null

    /**
     * @param value Configuration for an AWS Lambda function. See AWS Lambda below for more details.
     */
    @JvmName("purcdfaniebrookw")
    public suspend fun awsLambda(`value`: Output<ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs>) {
        this.awsLambda = value
    }

    /**
     * @param value Configuration for an AWS Lambda function. See AWS Lambda below for more details.
     */
    @JvmName("tlewopicywadijhv")
    public suspend fun awsLambda(`value`: ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.awsLambda = mapped
    }

    /**
     * @param argument Configuration for an AWS Lambda function. See AWS Lambda below for more details.
     */
    @JvmName("ciueqoeexshdnjth")
    public suspend fun awsLambda(argument: suspend ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgsBuilder.() -> Unit) {
        val toBeMapped =
            ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.awsLambda = mapped
    }

    internal fun build(): ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs =
        ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs(
            awsLambda = awsLambda ?: throw PulumiNullFieldException("awsLambda"),
        )
}
