@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property functionArn The Amazon Resource Name (ARN) of the AWS Lambda function.
 * @property functionPayload Additional JSON that provides supplemental data to the Lambda function used to transform objects.
 */
public data class
ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs(
    public val functionArn: Output<String>,
    public val functionPayload: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs =
        com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs.builder()
            .functionArn(functionArn.applyValue({ args0 -> args0 }))
            .functionPayload(functionPayload?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs].
 */
@PulumiTagMarker
public class
ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgsBuilder
internal constructor() {
    private var functionArn: Output<String>? = null

    private var functionPayload: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the AWS Lambda function.
     */
    @JvmName("felbtbnltjagnufg")
    public suspend fun functionArn(`value`: Output<String>) {
        this.functionArn = value
    }

    /**
     * @param value Additional JSON that provides supplemental data to the Lambda function used to transform objects.
     */
    @JvmName("hsvlodpfhuiibrpw")
    public suspend fun functionPayload(`value`: Output<String>) {
        this.functionPayload = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the AWS Lambda function.
     */
    @JvmName("hhdwtxdfgvlycntc")
    public suspend fun functionArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functionArn = mapped
    }

    /**
     * @param value Additional JSON that provides supplemental data to the Lambda function used to transform objects.
     */
    @JvmName("gipagfuaersluktl")
    public suspend fun functionPayload(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionPayload = mapped
    }

    internal fun build(): ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs =
        ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs(
            functionArn = functionArn ?: throw PulumiNullFieldException("functionArn"),
            functionPayload = functionPayload,
        )
}
