@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property activityMetrics S3 Storage Lens activity metrics. See Activity Metrics below for more details.
 * @property advancedCostOptimizationMetrics Advanced cost-optimization metrics for S3 Storage Lens. See Advanced Cost-Optimization Metrics below for more details.
 * @property advancedDataProtectionMetrics Advanced data-protection metrics for S3 Storage Lens. See Advanced Data-Protection Metrics below for more details.
 * @property bucketLevel S3 Storage Lens bucket-level configuration. See Bucket Level below for more details.
 * @property detailedStatusCodeMetrics Detailed status code metrics for S3 Storage Lens. See Detailed Status Code Metrics below for more details.
 */
public data class StorageLensConfigurationStorageLensConfigurationAccountLevelArgs(
    public val activityMetrics: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetricsArgs>? =
        null,
    public val advancedCostOptimizationMetrics: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedCostOptimizationMetricsArgs>? =
        null,
    public val advancedDataProtectionMetrics: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedDataProtectionMetricsArgs>? =
        null,
    public val bucketLevel: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs>,
    public val detailedStatusCodeMetrics: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelDetailedStatusCodeMetricsArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelArgs =
        com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelArgs.builder()
            .activityMetrics(activityMetrics?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .advancedCostOptimizationMetrics(
                advancedCostOptimizationMetrics?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .advancedDataProtectionMetrics(
                advancedDataProtectionMetrics?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .bucketLevel(bucketLevel.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .detailedStatusCodeMetrics(
                detailedStatusCodeMetrics?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [StorageLensConfigurationStorageLensConfigurationAccountLevelArgs].
 */
@PulumiTagMarker
public class StorageLensConfigurationStorageLensConfigurationAccountLevelArgsBuilder internal constructor() {
    private var activityMetrics:
        Output<StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetricsArgs>? =
        null

    private var advancedCostOptimizationMetrics:
        Output<StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedCostOptimizationMetricsArgs>? =
        null

    private var advancedDataProtectionMetrics:
        Output<StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedDataProtectionMetricsArgs>? =
        null

    private var bucketLevel:
        Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs>? = null

    private var detailedStatusCodeMetrics:
        Output<StorageLensConfigurationStorageLensConfigurationAccountLevelDetailedStatusCodeMetricsArgs>? =
        null

    /**
     * @param value S3 Storage Lens activity metrics. See Activity Metrics below for more details.
     */
    @JvmName("rprafjbfdolacmur")
    public suspend fun activityMetrics(`value`: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetricsArgs>) {
        this.activityMetrics = value
    }

    /**
     * @param value Advanced cost-optimization metrics for S3 Storage Lens. See Advanced Cost-Optimization Metrics below for more details.
     */
    @JvmName("rfsfkkbxkxdbqdjv")
    public suspend fun advancedCostOptimizationMetrics(`value`: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedCostOptimizationMetricsArgs>) {
        this.advancedCostOptimizationMetrics = value
    }

    /**
     * @param value Advanced data-protection metrics for S3 Storage Lens. See Advanced Data-Protection Metrics below for more details.
     */
    @JvmName("qsxacsbcntlbckno")
    public suspend fun advancedDataProtectionMetrics(`value`: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedDataProtectionMetricsArgs>) {
        this.advancedDataProtectionMetrics = value
    }

    /**
     * @param value S3 Storage Lens bucket-level configuration. See Bucket Level below for more details.
     */
    @JvmName("pqytwfqrktmvkbnk")
    public suspend fun bucketLevel(`value`: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs>) {
        this.bucketLevel = value
    }

    /**
     * @param value Detailed status code metrics for S3 Storage Lens. See Detailed Status Code Metrics below for more details.
     */
    @JvmName("tryuoxbdwxurbkwk")
    public suspend fun detailedStatusCodeMetrics(`value`: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelDetailedStatusCodeMetricsArgs>) {
        this.detailedStatusCodeMetrics = value
    }

    /**
     * @param value S3 Storage Lens activity metrics. See Activity Metrics below for more details.
     */
    @JvmName("edbfmuwppkrtkqjq")
    public suspend fun activityMetrics(`value`: StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetricsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activityMetrics = mapped
    }

    /**
     * @param argument S3 Storage Lens activity metrics. See Activity Metrics below for more details.
     */
    @JvmName("rqwmbyhsskbkqhfn")
    public suspend fun activityMetrics(argument: suspend StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetricsArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetricsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.activityMetrics = mapped
    }

    /**
     * @param value Advanced cost-optimization metrics for S3 Storage Lens. See Advanced Cost-Optimization Metrics below for more details.
     */
    @JvmName("vkkordhabfylaerv")
    public suspend fun advancedCostOptimizationMetrics(`value`: StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedCostOptimizationMetricsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedCostOptimizationMetrics = mapped
    }

    /**
     * @param argument Advanced cost-optimization metrics for S3 Storage Lens. See Advanced Cost-Optimization Metrics below for more details.
     */
    @JvmName("jxycjprnufbcsvpc")
    public suspend fun advancedCostOptimizationMetrics(argument: suspend StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedCostOptimizationMetricsArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedCostOptimizationMetricsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.advancedCostOptimizationMetrics = mapped
    }

    /**
     * @param value Advanced data-protection metrics for S3 Storage Lens. See Advanced Data-Protection Metrics below for more details.
     */
    @JvmName("rlvspksgpqthjure")
    public suspend fun advancedDataProtectionMetrics(`value`: StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedDataProtectionMetricsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedDataProtectionMetrics = mapped
    }

    /**
     * @param argument Advanced data-protection metrics for S3 Storage Lens. See Advanced Data-Protection Metrics below for more details.
     */
    @JvmName("lncdqolkqnbvxkhk")
    public suspend fun advancedDataProtectionMetrics(argument: suspend StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedDataProtectionMetricsArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedDataProtectionMetricsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.advancedDataProtectionMetrics = mapped
    }

    /**
     * @param value S3 Storage Lens bucket-level configuration. See Bucket Level below for more details.
     */
    @JvmName("sdwskdaqpalsgbqx")
    public suspend fun bucketLevel(`value`: StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketLevel = mapped
    }

    /**
     * @param argument S3 Storage Lens bucket-level configuration. See Bucket Level below for more details.
     */
    @JvmName("laqqonukrbxwwena")
    public suspend fun bucketLevel(argument: suspend StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.bucketLevel = mapped
    }

    /**
     * @param value Detailed status code metrics for S3 Storage Lens. See Detailed Status Code Metrics below for more details.
     */
    @JvmName("lkmasojxjbspwxmk")
    public suspend fun detailedStatusCodeMetrics(`value`: StorageLensConfigurationStorageLensConfigurationAccountLevelDetailedStatusCodeMetricsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detailedStatusCodeMetrics = mapped
    }

    /**
     * @param argument Detailed status code metrics for S3 Storage Lens. See Detailed Status Code Metrics below for more details.
     */
    @JvmName("ylbjdymbmxwbwish")
    public suspend fun detailedStatusCodeMetrics(argument: suspend StorageLensConfigurationStorageLensConfigurationAccountLevelDetailedStatusCodeMetricsArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationAccountLevelDetailedStatusCodeMetricsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.detailedStatusCodeMetrics = mapped
    }

    internal fun build(): StorageLensConfigurationStorageLensConfigurationAccountLevelArgs =
        StorageLensConfigurationStorageLensConfigurationAccountLevelArgs(
            activityMetrics = activityMetrics,
            advancedCostOptimizationMetrics = advancedCostOptimizationMetrics,
            advancedDataProtectionMetrics = advancedDataProtectionMetrics,
            bucketLevel = bucketLevel ?: throw PulumiNullFieldException("bucketLevel"),
            detailedStatusCodeMetrics = detailedStatusCodeMetrics,
        )
}
