@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property activityMetrics S3 Storage Lens activity metrics. See Activity Metrics above for more details.
 * @property advancedCostOptimizationMetrics Advanced cost-optimization metrics for S3 Storage Lens. See Advanced Cost-Optimization Metrics above for more details.
 * @property advancedDataProtectionMetrics Advanced data-protection metrics for S3 Storage Lens. See Advanced Data-Protection Metrics above for more details.
 * @property detailedStatusCodeMetrics Detailed status code metrics for S3 Storage Lens. See Detailed Status Code Metrics above for more details.
 * @property prefixLevel Prefix-level metrics for S3 Storage Lens. See Prefix Level below for more details.
 */
public data class StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs(
    public val activityMetrics: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetricsArgs>? =
        null,
    public val advancedCostOptimizationMetrics: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedCostOptimizationMetricsArgs>? =
        null,
    public val advancedDataProtectionMetrics: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedDataProtectionMetricsArgs>? =
        null,
    public val detailedStatusCodeMetrics: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelDetailedStatusCodeMetricsArgs>? =
        null,
    public val prefixLevel: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs =
        com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs.builder()
            .activityMetrics(activityMetrics?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .advancedCostOptimizationMetrics(
                advancedCostOptimizationMetrics?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .advancedDataProtectionMetrics(
                advancedDataProtectionMetrics?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .detailedStatusCodeMetrics(
                detailedStatusCodeMetrics?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .prefixLevel(prefixLevel?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs].
 */
@PulumiTagMarker
public class StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgsBuilder
internal constructor() {
    private var activityMetrics:
        Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetricsArgs>? =
        null

    private var advancedCostOptimizationMetrics:
        Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedCostOptimizationMetricsArgs>? =
        null

    private var advancedDataProtectionMetrics:
        Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedDataProtectionMetricsArgs>? =
        null

    private var detailedStatusCodeMetrics:
        Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelDetailedStatusCodeMetricsArgs>? =
        null

    private var prefixLevel:
        Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelArgs>? =
        null

    /**
     * @param value S3 Storage Lens activity metrics. See Activity Metrics above for more details.
     */
    @JvmName("itlmgxlcdsmpjwtm")
    public suspend fun activityMetrics(`value`: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetricsArgs>) {
        this.activityMetrics = value
    }

    /**
     * @param value Advanced cost-optimization metrics for S3 Storage Lens. See Advanced Cost-Optimization Metrics above for more details.
     */
    @JvmName("odyqrhiiuhimnncn")
    public suspend fun advancedCostOptimizationMetrics(`value`: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedCostOptimizationMetricsArgs>) {
        this.advancedCostOptimizationMetrics = value
    }

    /**
     * @param value Advanced data-protection metrics for S3 Storage Lens. See Advanced Data-Protection Metrics above for more details.
     */
    @JvmName("wiqtlfjetmifbryo")
    public suspend fun advancedDataProtectionMetrics(`value`: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedDataProtectionMetricsArgs>) {
        this.advancedDataProtectionMetrics = value
    }

    /**
     * @param value Detailed status code metrics for S3 Storage Lens. See Detailed Status Code Metrics above for more details.
     */
    @JvmName("oqaugtgdywptwdcm")
    public suspend fun detailedStatusCodeMetrics(`value`: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelDetailedStatusCodeMetricsArgs>) {
        this.detailedStatusCodeMetrics = value
    }

    /**
     * @param value Prefix-level metrics for S3 Storage Lens. See Prefix Level below for more details.
     */
    @JvmName("jmalnbkoeeqcmheu")
    public suspend fun prefixLevel(`value`: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelArgs>) {
        this.prefixLevel = value
    }

    /**
     * @param value S3 Storage Lens activity metrics. See Activity Metrics above for more details.
     */
    @JvmName("xdksbukbhisnnmah")
    public suspend fun activityMetrics(`value`: StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetricsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activityMetrics = mapped
    }

    /**
     * @param argument S3 Storage Lens activity metrics. See Activity Metrics above for more details.
     */
    @JvmName("bhyhwhnuoavpjbbj")
    public suspend fun activityMetrics(argument: suspend StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetricsArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetricsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.activityMetrics = mapped
    }

    /**
     * @param value Advanced cost-optimization metrics for S3 Storage Lens. See Advanced Cost-Optimization Metrics above for more details.
     */
    @JvmName("htllkwbvasjkqldo")
    public suspend fun advancedCostOptimizationMetrics(`value`: StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedCostOptimizationMetricsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedCostOptimizationMetrics = mapped
    }

    /**
     * @param argument Advanced cost-optimization metrics for S3 Storage Lens. See Advanced Cost-Optimization Metrics above for more details.
     */
    @JvmName("scvovlgwlhbxoqdd")
    public suspend fun advancedCostOptimizationMetrics(argument: suspend StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedCostOptimizationMetricsArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedCostOptimizationMetricsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.advancedCostOptimizationMetrics = mapped
    }

    /**
     * @param value Advanced data-protection metrics for S3 Storage Lens. See Advanced Data-Protection Metrics above for more details.
     */
    @JvmName("nqxabibhsurcoqdr")
    public suspend fun advancedDataProtectionMetrics(`value`: StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedDataProtectionMetricsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedDataProtectionMetrics = mapped
    }

    /**
     * @param argument Advanced data-protection metrics for S3 Storage Lens. See Advanced Data-Protection Metrics above for more details.
     */
    @JvmName("djyilxucgfjpfvqf")
    public suspend fun advancedDataProtectionMetrics(argument: suspend StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedDataProtectionMetricsArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedDataProtectionMetricsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.advancedDataProtectionMetrics = mapped
    }

    /**
     * @param value Detailed status code metrics for S3 Storage Lens. See Detailed Status Code Metrics above for more details.
     */
    @JvmName("uxvynqncbveypqqk")
    public suspend fun detailedStatusCodeMetrics(`value`: StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelDetailedStatusCodeMetricsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detailedStatusCodeMetrics = mapped
    }

    /**
     * @param argument Detailed status code metrics for S3 Storage Lens. See Detailed Status Code Metrics above for more details.
     */
    @JvmName("mtyryfetgaiejtfw")
    public suspend fun detailedStatusCodeMetrics(argument: suspend StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelDetailedStatusCodeMetricsArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelDetailedStatusCodeMetricsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.detailedStatusCodeMetrics = mapped
    }

    /**
     * @param value Prefix-level metrics for S3 Storage Lens. See Prefix Level below for more details.
     */
    @JvmName("woiyooucwqumhlaq")
    public suspend fun prefixLevel(`value`: StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixLevel = mapped
    }

    /**
     * @param argument Prefix-level metrics for S3 Storage Lens. See Prefix Level below for more details.
     */
    @JvmName("bljfkhxubukmiaij")
    public suspend fun prefixLevel(argument: suspend StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.prefixLevel = mapped
    }

    internal fun build(): StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs = StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs(
        activityMetrics = activityMetrics,
        advancedCostOptimizationMetrics = advancedCostOptimizationMetrics,
        advancedDataProtectionMetrics = advancedDataProtectionMetrics,
        detailedStatusCodeMetrics = detailedStatusCodeMetrics,
        prefixLevel = prefixLevel,
    )
}
