@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property storageMetrics Prefix-level storage metrics for S3 Storage Lens. See Prefix Level Storage Metrics below for more details.
 */
public data class
StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelArgs(
    public val storageMetrics: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelArgs =
        com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelArgs.builder()
            .storageMetrics(
                storageMetrics.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelArgs].
 */
@PulumiTagMarker
public class
StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelArgsBuilder
internal constructor() {
    private var storageMetrics:
        Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsArgs>? =
        null

    /**
     * @param value Prefix-level storage metrics for S3 Storage Lens. See Prefix Level Storage Metrics below for more details.
     */
    @JvmName("sgmlupraeggvjikn")
    public suspend fun storageMetrics(`value`: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsArgs>) {
        this.storageMetrics = value
    }

    /**
     * @param value Prefix-level storage metrics for S3 Storage Lens. See Prefix Level Storage Metrics below for more details.
     */
    @JvmName("lnugpwfbgindudym")
    public suspend fun storageMetrics(`value`: StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageMetrics = mapped
    }

    /**
     * @param argument Prefix-level storage metrics for S3 Storage Lens. See Prefix Level Storage Metrics below for more details.
     */
    @JvmName("nkebfrmixdfkwman")
    public suspend fun storageMetrics(argument: suspend StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.storageMetrics = mapped
    }

    internal fun build(): StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelArgs =
        StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelArgs(
            storageMetrics = storageMetrics ?: throw PulumiNullFieldException("storageMetrics"),
        )
}
