@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether prefix-level storage metrics are enabled.
 * @property selectionCriteria Selection criteria. See Selection Criteria below for more details.
 */
public data class
StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsArgs(
    public val enabled: Output<Boolean>? = null,
    public val selectionCriteria: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteriaArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsArgs =
        com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .selectionCriteria(
                selectionCriteria?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsArgs].
 */
@PulumiTagMarker
public class
StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsArgsBuilder
internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var selectionCriteria:
        Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteriaArgs>? =
        null

    /**
     * @param value Whether prefix-level storage metrics are enabled.
     */
    @JvmName("suamnmbhrijdrvwo")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Selection criteria. See Selection Criteria below for more details.
     */
    @JvmName("vlgfxgvfxtanggrg")
    public suspend fun selectionCriteria(`value`: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteriaArgs>) {
        this.selectionCriteria = value
    }

    /**
     * @param value Whether prefix-level storage metrics are enabled.
     */
    @JvmName("ohessgebwpaqefas")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Selection criteria. See Selection Criteria below for more details.
     */
    @JvmName("miprxpfarkfdgmxb")
    public suspend fun selectionCriteria(`value`: StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteriaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectionCriteria = mapped
    }

    /**
     * @param argument Selection criteria. See Selection Criteria below for more details.
     */
    @JvmName("xlkjhkwgmsrrjrlp")
    public suspend fun selectionCriteria(argument: suspend StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteriaArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.selectionCriteria = mapped
    }

    internal fun build(): StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsArgs =
        StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsArgs(
            enabled = enabled,
            selectionCriteria = selectionCriteria,
        )
}
