@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteriaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property delimiter The delimiter of the selection criteria being used.
 * @property maxDepth The max depth of the selection criteria.
 * @property minStorageBytesPercentage The minimum number of storage bytes percentage whose metrics will be selected.
 */
public data class
StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteriaArgs(
    public val delimiter: Output<String>? = null,
    public val maxDepth: Output<Int>? = null,
    public val minStorageBytesPercentage: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteriaArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteriaArgs =
        com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteriaArgs.builder()
            .delimiter(delimiter?.applyValue({ args0 -> args0 }))
            .maxDepth(maxDepth?.applyValue({ args0 -> args0 }))
            .minStorageBytesPercentage(minStorageBytesPercentage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteriaArgs].
 */
@PulumiTagMarker
public class
StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteriaArgsBuilder
internal constructor() {
    private var delimiter: Output<String>? = null

    private var maxDepth: Output<Int>? = null

    private var minStorageBytesPercentage: Output<Double>? = null

    /**
     * @param value The delimiter of the selection criteria being used.
     */
    @JvmName("jwocsnrkbusoqsas")
    public suspend fun delimiter(`value`: Output<String>) {
        this.delimiter = value
    }

    /**
     * @param value The max depth of the selection criteria.
     */
    @JvmName("xcadlsbdsenwukpi")
    public suspend fun maxDepth(`value`: Output<Int>) {
        this.maxDepth = value
    }

    /**
     * @param value The minimum number of storage bytes percentage whose metrics will be selected.
     */
    @JvmName("cqtiwomwgaoiynwy")
    public suspend fun minStorageBytesPercentage(`value`: Output<Double>) {
        this.minStorageBytesPercentage = value
    }

    /**
     * @param value The delimiter of the selection criteria being used.
     */
    @JvmName("atiicysahpgfraaq")
    public suspend fun delimiter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delimiter = mapped
    }

    /**
     * @param value The max depth of the selection criteria.
     */
    @JvmName("uoawuhpmitijbsxk")
    public suspend fun maxDepth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxDepth = mapped
    }

    /**
     * @param value The minimum number of storage bytes percentage whose metrics will be selected.
     */
    @JvmName("fhviwxkpuyvjqcgj")
    public suspend fun minStorageBytesPercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minStorageBytesPercentage = mapped
    }

    internal fun build(): StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteriaArgs =
        StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteriaArgs(
            delimiter = delimiter,
            maxDepth = maxDepth,
            minStorageBytesPercentage = minStorageBytesPercentage,
        )
}
