@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether CloudWatch publishing for S3 Storage Lens metrics is enabled.
 */
public data class StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs(
    public val enabled: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs =
        com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs].
 */
@PulumiTagMarker
public class StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgsBuilder
internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Whether CloudWatch publishing for S3 Storage Lens metrics is enabled.
     */
    @JvmName("prgqnlipqtwejryi")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Whether CloudWatch publishing for S3 Storage Lens metrics is enabled.
     */
    @JvmName("xayscqeogublnngh")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs =
        StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs(
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        )
}
