@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accountId The account ID of the owner of the S3 Storage Lens metrics export bucket.
 * @property arn The Amazon Resource Name (ARN) of the bucket.
 * @property encryption Encryption of the metrics exports in this bucket. See Encryption below for more details.
 * @property format The export format. Valid values: `CSV`, `Parquet`.
 * @property outputSchemaVersion The schema version of the export file. Valid values: `V_1`.
 * @property prefix The prefix of the destination bucket where the metrics export will be delivered.
 */
public data class StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs(
    public val accountId: Output<String>,
    public val arn: Output<String>,
    public val encryption: Output<StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs>? =
        null,
    public val format: Output<String>,
    public val outputSchemaVersion: Output<String>,
    public val prefix: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs =
        com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs.builder()
            .accountId(accountId.applyValue({ args0 -> args0 }))
            .arn(arn.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .format(format.applyValue({ args0 -> args0 }))
            .outputSchemaVersion(outputSchemaVersion.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs].
 */
@PulumiTagMarker
public class
StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgsBuilder
internal constructor() {
    private var accountId: Output<String>? = null

    private var arn: Output<String>? = null

    private var encryption:
        Output<StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs>? =
        null

    private var format: Output<String>? = null

    private var outputSchemaVersion: Output<String>? = null

    private var prefix: Output<String>? = null

    /**
     * @param value The account ID of the owner of the S3 Storage Lens metrics export bucket.
     */
    @JvmName("vsplgxtjokwrjgqy")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the bucket.
     */
    @JvmName("hbtycjkcksjiresu")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value Encryption of the metrics exports in this bucket. See Encryption below for more details.
     */
    @JvmName("tftgcyoahawhgbqt")
    public suspend fun encryption(`value`: Output<StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value The export format. Valid values: `CSV`, `Parquet`.
     */
    @JvmName("akdwwxviowskyemn")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value The schema version of the export file. Valid values: `V_1`.
     */
    @JvmName("xbuegtmcbkoucqdk")
    public suspend fun outputSchemaVersion(`value`: Output<String>) {
        this.outputSchemaVersion = value
    }

    /**
     * @param value The prefix of the destination bucket where the metrics export will be delivered.
     */
    @JvmName("sruudvvcmkkawrau")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value The account ID of the owner of the S3 Storage Lens metrics export bucket.
     */
    @JvmName("yxbeerkbjtqgiyxl")
    public suspend fun accountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the bucket.
     */
    @JvmName("gafeebqitejpbtad")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value Encryption of the metrics exports in this bucket. See Encryption below for more details.
     */
    @JvmName("ixwlyxbycmsfvibb")
    public suspend fun encryption(`value`: StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Encryption of the metrics exports in this bucket. See Encryption below for more details.
     */
    @JvmName("lgpfiqireqmhldpr")
    public suspend fun encryption(argument: suspend StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value The export format. Valid values: `CSV`, `Parquet`.
     */
    @JvmName("wsoygwojxncwobwq")
    public suspend fun format(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value The schema version of the export file. Valid values: `V_1`.
     */
    @JvmName("datynbqjklpnkuyy")
    public suspend fun outputSchemaVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputSchemaVersion = mapped
    }

    /**
     * @param value The prefix of the destination bucket where the metrics export will be delivered.
     */
    @JvmName("pcyrlkcalhyagrju")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs =
        StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs(
            accountId = accountId ?: throw PulumiNullFieldException("accountId"),
            arn = arn ?: throw PulumiNullFieldException("arn"),
            encryption = encryption,
            format = format ?: throw PulumiNullFieldException("format"),
            outputSchemaVersion = outputSchemaVersion ?: throw PulumiNullFieldException("outputSchemaVersion"),
            prefix = prefix,
        )
}
