@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property granteeIdentifier Grantee identifier.
 * @property granteeType Grantee types. Valid values: `DIRECTORY_USER`, `DIRECTORY_GROUP`, `IAM`.
 */
public data class AccessGrantGrantee(
    public val granteeIdentifier: String,
    public val granteeType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3control.outputs.AccessGrantGrantee): AccessGrantGrantee = AccessGrantGrantee(
            granteeIdentifier = javaType.granteeIdentifier(),
            granteeType = javaType.granteeType(),
        )
    }
}
