@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property abortIncompleteMultipartUpload Configuration block containing settings for abort incomplete multipart upload.
 * @property expiration Configuration block containing settings for expiration of objects.
 * @property filter Configuration block containing settings for filtering.
 * @property id Unique identifier for the rule.
 * @property status Status of the rule. Valid values: `Enabled` and `Disabled`. Defaults to `Enabled`.
 */
public data class BucketLifecycleConfigurationRule(
    public val abortIncompleteMultipartUpload: BucketLifecycleConfigurationRuleAbortIncompleteMultipartUpload? = null,
    public val expiration: BucketLifecycleConfigurationRuleExpiration? = null,
    public val filter: BucketLifecycleConfigurationRuleFilter? = null,
    public val id: String,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3control.outputs.BucketLifecycleConfigurationRule): BucketLifecycleConfigurationRule = BucketLifecycleConfigurationRule(
            abortIncompleteMultipartUpload = javaType.abortIncompleteMultipartUpload().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3control.kotlin.outputs.BucketLifecycleConfigurationRuleAbortIncompleteMultipartUpload.Companion.toKotlin(args0)
                })
            }).orElse(null),
            expiration = javaType.expiration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3control.kotlin.outputs.BucketLifecycleConfigurationRuleExpiration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            filter = javaType.filter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3control.kotlin.outputs.BucketLifecycleConfigurationRuleFilter.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
