@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property date Date the object is to be deleted. Should be in `YYYY-MM-DD` date format, e.g., `2020-09-30`.
 * @property days Number of days before the object is to be deleted.
 * @property expiredObjectDeleteMarker Enable to remove a delete marker with no noncurrent versions. Cannot be specified with `date` or `days`.
 */
public data class BucketLifecycleConfigurationRuleExpiration(
    public val date: String? = null,
    public val days: Int? = null,
    public val expiredObjectDeleteMarker: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3control.outputs.BucketLifecycleConfigurationRuleExpiration): BucketLifecycleConfigurationRuleExpiration = BucketLifecycleConfigurationRuleExpiration(
            date = javaType.date().map({ args0 -> args0 }).orElse(null),
            days = javaType.days().map({ args0 -> args0 }).orElse(null),
            expiredObjectDeleteMarker = javaType.expiredObjectDeleteMarker().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
