@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property blockPublicAcls Specifies whether Amazon S3 should block public access control lists (ACLs). When set to `true` causes the following behavior:
 * * PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
 * * PUT Object calls fail if the request includes a public ACL.
 * * PUT Bucket calls fail if the request includes a public ACL.
 * @property blockPublicPolicy Specifies whether Amazon S3 should block public bucket policies for buckets in this account. When set to `true` causes Amazon S3 to:
 * * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
 * @property ignorePublicAcls Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. When set to `true` causes Amazon S3 to:
 * * Ignore all public ACLs on buckets in this account and any objects that they contain.
 * @property restrictPublicBuckets Specifies whether Amazon S3 should restrict public bucket policies for buckets in this account. When set to `true`:
 * * Only the bucket owner and AWS Services can access buckets with public policies.
 */
public data class GetMultiRegionAccessPointPublicAccessBlock(
    public val blockPublicAcls: Boolean,
    public val blockPublicPolicy: Boolean,
    public val ignorePublicAcls: Boolean,
    public val restrictPublicBuckets: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3control.outputs.GetMultiRegionAccessPointPublicAccessBlock): GetMultiRegionAccessPointPublicAccessBlock = GetMultiRegionAccessPointPublicAccessBlock(
            blockPublicAcls = javaType.blockPublicAcls(),
            blockPublicPolicy = javaType.blockPublicPolicy(),
            ignorePublicAcls = javaType.ignorePublicAcls(),
            restrictPublicBuckets = javaType.restrictPublicBuckets(),
        )
    }
}
