@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket The name of the bucket.
 * @property bucketAccountId The AWS account ID that owns the bucket.
 * @property region The name of the region.
 */
public data class GetMultiRegionAccessPointRegion(
    public val bucket: String,
    public val bucketAccountId: String,
    public val region: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3control.outputs.GetMultiRegionAccessPointRegion): GetMultiRegionAccessPointRegion = GetMultiRegionAccessPointRegion(
            bucket = javaType.bucket(),
            bucketAccountId = javaType.bucketAccountId(),
            region = javaType.region(),
        )
    }
}
