@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getMultiRegionAccessPoint.
 * @property accountId
 * @property alias The alias for the Multi-Region Access Point.
 * @property arn Amazon Resource Name (ARN) of the Multi-Region Access Point.
 * @property createdAt Timestamp when the resource has been created.
 * @property domainName The DNS domain name of the S3 Multi-Region Access Point in the format _`alias`_.accesspoint.s3-global.amazonaws.com. For more information, see the documentation on [Multi-Region Access Point Requests](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRequests.html).
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property publicAccessBlocks Public Access Block of the Multi-Region Access Point. Detailed below.
 * @property regions A collection of the regions and buckets associated with the Multi-Region Access Point.
 * @property status The current status of the Multi-Region Access Point.
 */
public data class GetMultiRegionAccessPointResult(
    public val accountId: String,
    public val alias: String,
    public val arn: String,
    public val createdAt: String,
    public val domainName: String,
    public val id: String,
    public val name: String,
    public val publicAccessBlocks: List<GetMultiRegionAccessPointPublicAccessBlock>,
    public val regions: List<GetMultiRegionAccessPointRegion>,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3control.outputs.GetMultiRegionAccessPointResult): GetMultiRegionAccessPointResult = GetMultiRegionAccessPointResult(
            accountId = javaType.accountId(),
            alias = javaType.alias(),
            arn = javaType.arn(),
            createdAt = javaType.createdAt(),
            domainName = javaType.domainName(),
            id = javaType.id(),
            name = javaType.name(),
            publicAccessBlocks = javaType.publicAccessBlocks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3control.kotlin.outputs.GetMultiRegionAccessPointPublicAccessBlock.Companion.toKotlin(args0)
                })
            }),
            regions = javaType.regions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3control.kotlin.outputs.GetMultiRegionAccessPointRegion.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
        )
    }
}
