@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property blockPublicAcls
 * @property blockPublicPolicy
 * @property ignorePublicAcls
 * @property restrictPublicBuckets
 */
public data class MultiRegionAccessPointDetailsPublicAccessBlock(
    public val blockPublicAcls: Boolean? = null,
    public val blockPublicPolicy: Boolean? = null,
    public val ignorePublicAcls: Boolean? = null,
    public val restrictPublicBuckets: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3control.outputs.MultiRegionAccessPointDetailsPublicAccessBlock): MultiRegionAccessPointDetailsPublicAccessBlock =
            MultiRegionAccessPointDetailsPublicAccessBlock(
                blockPublicAcls = javaType.blockPublicAcls().map({ args0 -> args0 }).orElse(null),
                blockPublicPolicy = javaType.blockPublicPolicy().map({ args0 -> args0 }).orElse(null),
                ignorePublicAcls = javaType.ignorePublicAcls().map({ args0 -> args0 }).orElse(null),
                restrictPublicBuckets = javaType.restrictPublicBuckets().map({ args0 -> args0 }).orElse(null),
            )
    }
}
