@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name The name of the Multi-Region Access Point.
 * @property policy A valid JSON document that specifies the policy that you want to associate with this Multi-Region Access Point. Once applied, the policy can be edited, but not deleted. For more information, see the documentation on [Multi-Region Access Point Permissions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointPermissions.html).
 * > **NOTE:** When you update the `policy`, the update is first listed as the proposed policy. After the update is finished and all Regions have been updated, the proposed policy is listed as the established policy. If both policies have the same version number, the proposed policy is the established policy.
 */
public data class MultiRegionAccessPointPolicyDetails(
    public val name: String,
    public val policy: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3control.outputs.MultiRegionAccessPointPolicyDetails): MultiRegionAccessPointPolicyDetails = MultiRegionAccessPointPolicyDetails(
            name = javaType.name(),
            policy = javaType.policy(),
        )
    }
}
