@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property actions The actions of an Object Lambda Access Point configuration. Valid values: `GetObject`.
 * @property contentTransformation The content transformation of an Object Lambda Access Point configuration. See Content Transformation below for more details.
 */
public data class ObjectLambdaAccessPointConfigurationTransformationConfiguration(
    public val actions: List<String>,
    public val contentTransformation: ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformation,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3control.outputs.ObjectLambdaAccessPointConfigurationTransformationConfiguration): ObjectLambdaAccessPointConfigurationTransformationConfiguration =
            ObjectLambdaAccessPointConfigurationTransformationConfiguration(
                actions = javaType.actions().map({ args0 -> args0 }),
                contentTransformation = javaType.contentTransformation().let({ args0 ->
                    com.pulumi.aws.s3control.kotlin.outputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformation.Companion.toKotlin(args0)
                }),
            )
    }
}
