@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property accountLevel The account-level configurations of the S3 Storage Lens configuration. See Account Level below for more details.
 * @property awsOrg The Amazon Web Services organization for the S3 Storage Lens configuration. See AWS Org below for more details.
 * @property dataExport Properties of S3 Storage Lens metrics export including the destination, schema and format. See Data Export below for more details.
 * @property enabled Whether the S3 Storage Lens configuration is enabled.
 * @property exclude What is excluded in this configuration. Conflicts with `include`. See Exclude below for more details.
 * @property include What is included in this configuration. Conflicts with `exclude`. See Include below for more details.
 */
public data class StorageLensConfigurationStorageLensConfiguration(
    public val accountLevel: StorageLensConfigurationStorageLensConfigurationAccountLevel,
    public val awsOrg: StorageLensConfigurationStorageLensConfigurationAwsOrg? = null,
    public val dataExport: StorageLensConfigurationStorageLensConfigurationDataExport? = null,
    public val enabled: Boolean,
    public val exclude: StorageLensConfigurationStorageLensConfigurationExclude? = null,
    public val include: StorageLensConfigurationStorageLensConfigurationInclude? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3control.outputs.StorageLensConfigurationStorageLensConfiguration): StorageLensConfigurationStorageLensConfiguration =
            StorageLensConfigurationStorageLensConfiguration(
                accountLevel = javaType.accountLevel().let({ args0 ->
                    com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfigurationAccountLevel.Companion.toKotlin(args0)
                }),
                awsOrg = javaType.awsOrg().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfigurationAwsOrg.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                dataExport = javaType.dataExport().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfigurationDataExport.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                enabled = javaType.enabled(),
                exclude = javaType.exclude().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfigurationExclude.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                include = javaType.include().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfigurationInclude.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
