@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property activityMetrics S3 Storage Lens activity metrics. See Activity Metrics below for more details.
 * @property advancedCostOptimizationMetrics Advanced cost-optimization metrics for S3 Storage Lens. See Advanced Cost-Optimization Metrics below for more details.
 * @property advancedDataProtectionMetrics Advanced data-protection metrics for S3 Storage Lens. See Advanced Data-Protection Metrics below for more details.
 * @property bucketLevel S3 Storage Lens bucket-level configuration. See Bucket Level below for more details.
 * @property detailedStatusCodeMetrics Detailed status code metrics for S3 Storage Lens. See Detailed Status Code Metrics below for more details.
 */
public data class StorageLensConfigurationStorageLensConfigurationAccountLevel(
    public val activityMetrics: StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetrics? = null,
    public val advancedCostOptimizationMetrics: StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedCostOptimizationMetrics? =
        null,
    public val advancedDataProtectionMetrics: StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedDataProtectionMetrics? =
        null,
    public val bucketLevel: StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevel,
    public val detailedStatusCodeMetrics: StorageLensConfigurationStorageLensConfigurationAccountLevelDetailedStatusCodeMetrics? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3control.outputs.StorageLensConfigurationStorageLensConfigurationAccountLevel): StorageLensConfigurationStorageLensConfigurationAccountLevel =
            StorageLensConfigurationStorageLensConfigurationAccountLevel(
                activityMetrics = javaType.activityMetrics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetrics.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                advancedCostOptimizationMetrics = javaType.advancedCostOptimizationMetrics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedCostOptimizationMetrics.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                advancedDataProtectionMetrics = javaType.advancedDataProtectionMetrics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedDataProtectionMetrics.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                bucketLevel = javaType.bucketLevel().let({ args0 ->
                    com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevel.Companion.toKotlin(args0)
                }),
                detailedStatusCodeMetrics = javaType.detailedStatusCodeMetrics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelDetailedStatusCodeMetrics.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
