@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property activityMetrics S3 Storage Lens activity metrics. See Activity Metrics above for more details.
 * @property advancedCostOptimizationMetrics Advanced cost-optimization metrics for S3 Storage Lens. See Advanced Cost-Optimization Metrics above for more details.
 * @property advancedDataProtectionMetrics Advanced data-protection metrics for S3 Storage Lens. See Advanced Data-Protection Metrics above for more details.
 * @property detailedStatusCodeMetrics Detailed status code metrics for S3 Storage Lens. See Detailed Status Code Metrics above for more details.
 * @property prefixLevel Prefix-level metrics for S3 Storage Lens. See Prefix Level below for more details.
 */
public data class StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevel(
    public val activityMetrics: StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetrics? =
        null,
    public val advancedCostOptimizationMetrics: StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedCostOptimizationMetrics? =
        null,
    public val advancedDataProtectionMetrics: StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedDataProtectionMetrics? =
        null,
    public val detailedStatusCodeMetrics: StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelDetailedStatusCodeMetrics? =
        null,
    public val prefixLevel: StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevel? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3control.outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevel): StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevel =
            StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevel(
                activityMetrics = javaType.activityMetrics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetrics.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                advancedCostOptimizationMetrics = javaType.advancedCostOptimizationMetrics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedCostOptimizationMetrics.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                advancedDataProtectionMetrics = javaType.advancedDataProtectionMetrics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedDataProtectionMetrics.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                detailedStatusCodeMetrics = javaType.detailedStatusCodeMetrics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelDetailedStatusCodeMetrics.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                prefixLevel = javaType.prefixLevel().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevel.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
