@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3outposts.kotlin

import com.pulumi.aws.s3outposts.EndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an S3 Outposts Endpoint.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3outposts.Endpoint("example", {
 *     outpostId: exampleAwsOutpostsOutpost.id,
 *     securityGroupId: exampleAwsSecurityGroup.id,
 *     subnetId: exampleAwsSubnet.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3outposts.Endpoint("example",
 *     outpost_id=example_aws_outposts_outpost["id"],
 *     security_group_id=example_aws_security_group["id"],
 *     subnet_id=example_aws_subnet["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3Outposts.Endpoint("example", new()
 *     {
 *         OutpostId = exampleAwsOutpostsOutpost.Id,
 *         SecurityGroupId = exampleAwsSecurityGroup.Id,
 *         SubnetId = exampleAwsSubnet.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3outposts"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := s3outposts.NewEndpoint(ctx, "example", &s3outposts.EndpointArgs{
 * 			OutpostId:       pulumi.Any(exampleAwsOutpostsOutpost.Id),
 * 			SecurityGroupId: pulumi.Any(exampleAwsSecurityGroup.Id),
 * 			SubnetId:        pulumi.Any(exampleAwsSubnet.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3outposts.Endpoint;
 * import com.pulumi.aws.s3outposts.EndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Endpoint("example", EndpointArgs.builder()
 *             .outpostId(exampleAwsOutpostsOutpost.id())
 *             .securityGroupId(exampleAwsSecurityGroup.id())
 *             .subnetId(exampleAwsSubnet.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3outposts:Endpoint
 *     properties:
 *       outpostId: ${exampleAwsOutpostsOutpost.id}
 *       securityGroupId: ${exampleAwsSecurityGroup.id}
 *       subnetId: ${exampleAwsSubnet.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import S3 Outposts Endpoints using Amazon Resource Name (ARN), EC2 Security Group identifier, and EC2 Subnet identifier, separated by commas (`,`). For example:
 * ```sh
 * $ pulumi import aws:s3outposts/endpoint:Endpoint example arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-12345678/endpoint/0123456789abcdef,sg-12345678,subnet-12345678
 * ```
 * @property accessType Type of access for the network connectivity. Valid values are `Private` or `CustomerOwnedIp`.
 * @property customerOwnedIpv4Pool The ID of a Customer Owned IP Pool. For more on customer owned IP addresses see the [User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/local-rack.html#local-gateway-subnet).
 * @property outpostId Identifier of the Outpost to contain this endpoint.
 * @property securityGroupId Identifier of the EC2 Security Group.
 * @property subnetId Identifier of the EC2 Subnet.
 */
public data class EndpointArgs(
    public val accessType: Output<String>? = null,
    public val customerOwnedIpv4Pool: Output<String>? = null,
    public val outpostId: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val subnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3outposts.EndpointArgs> {
    override fun toJava(): com.pulumi.aws.s3outposts.EndpointArgs =
        com.pulumi.aws.s3outposts.EndpointArgs.builder()
            .accessType(accessType?.applyValue({ args0 -> args0 }))
            .customerOwnedIpv4Pool(customerOwnedIpv4Pool?.applyValue({ args0 -> args0 }))
            .outpostId(outpostId?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointArgs].
 */
@PulumiTagMarker
public class EndpointArgsBuilder internal constructor() {
    private var accessType: Output<String>? = null

    private var customerOwnedIpv4Pool: Output<String>? = null

    private var outpostId: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value Type of access for the network connectivity. Valid values are `Private` or `CustomerOwnedIp`.
     */
    @JvmName("ptmlktvjbdevijrl")
    public suspend fun accessType(`value`: Output<String>) {
        this.accessType = value
    }

    /**
     * @param value The ID of a Customer Owned IP Pool. For more on customer owned IP addresses see the [User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/local-rack.html#local-gateway-subnet).
     */
    @JvmName("njklfqpictmcvgtl")
    public suspend fun customerOwnedIpv4Pool(`value`: Output<String>) {
        this.customerOwnedIpv4Pool = value
    }

    /**
     * @param value Identifier of the Outpost to contain this endpoint.
     */
    @JvmName("ylbaqeowyiltheor")
    public suspend fun outpostId(`value`: Output<String>) {
        this.outpostId = value
    }

    /**
     * @param value Identifier of the EC2 Security Group.
     */
    @JvmName("glkaoelvykbvkpdg")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value Identifier of the EC2 Subnet.
     */
    @JvmName("tjqqvavjordbtlkq")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Type of access for the network connectivity. Valid values are `Private` or `CustomerOwnedIp`.
     */
    @JvmName("itmguyixkioacpmp")
    public suspend fun accessType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessType = mapped
    }

    /**
     * @param value The ID of a Customer Owned IP Pool. For more on customer owned IP addresses see the [User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/local-rack.html#local-gateway-subnet).
     */
    @JvmName("urlnlfxymqsypihu")
    public suspend fun customerOwnedIpv4Pool(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerOwnedIpv4Pool = mapped
    }

    /**
     * @param value Identifier of the Outpost to contain this endpoint.
     */
    @JvmName("fbdpkqkhfdrrwfyv")
    public suspend fun outpostId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outpostId = mapped
    }

    /**
     * @param value Identifier of the EC2 Security Group.
     */
    @JvmName("rmotoyjujwabyuko")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value Identifier of the EC2 Subnet.
     */
    @JvmName("ipbbybdfkgrgrcip")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): EndpointArgs = EndpointArgs(
        accessType = accessType,
        customerOwnedIpv4Pool = customerOwnedIpv4Pool,
        outpostId = outpostId,
        securityGroupId = securityGroupId,
        subnetId = subnetId,
    )
}
