@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.AppImageConfigCodeEditorAppImageConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.AppImageConfigJupyterLabImageConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.AppImageConfigKernelGatewayImageConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.sagemaker.kotlin.outputs.AppImageConfigCodeEditorAppImageConfig.Companion.toKotlin as appImageConfigCodeEditorAppImageConfigToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.AppImageConfigJupyterLabImageConfig.Companion.toKotlin as appImageConfigJupyterLabImageConfigToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.AppImageConfigKernelGatewayImageConfig.Companion.toKotlin as appImageConfigKernelGatewayImageConfigToKotlin

/**
 * Builder for [AppImageConfig].
 */
@PulumiTagMarker
public class AppImageConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppImageConfigArgs = AppImageConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppImageConfigArgsBuilder.() -> Unit) {
        val builder = AppImageConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AppImageConfig {
        val builtJavaResource = com.pulumi.aws.sagemaker.AppImageConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AppImageConfig(builtJavaResource)
    }
}

/**
 * Provides a SageMaker App Image Config resource.
 * ## Example Usage
 * ### Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.AppImageConfig;
 * import com.pulumi.aws.sagemaker.AppImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AppImageConfig("test", AppImageConfigArgs.builder()
 *             .appImageConfigName("example")
 *             .kernelGatewayImageConfig(AppImageConfigKernelGatewayImageConfigArgs.builder()
 *                 .kernelSpecs(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:sagemaker:AppImageConfig
 *     properties:
 *       appImageConfigName: example
 *       kernelGatewayImageConfig:
 *         kernelSpecs:
 *           - name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Default File System Config
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.AppImageConfig;
 * import com.pulumi.aws.sagemaker.AppImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigFileSystemConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AppImageConfig("test", AppImageConfigArgs.builder()
 *             .appImageConfigName("example")
 *             .kernelGatewayImageConfig(AppImageConfigKernelGatewayImageConfigArgs.builder()
 *                 .kernelSpecs(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .fileSystemConfig()
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:sagemaker:AppImageConfig
 *     properties:
 *       appImageConfigName: example
 *       kernelGatewayImageConfig:
 *         kernelSpecs:
 *           - name: example
 *         fileSystemConfig: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker App Image Configs using the `name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/appImageConfig:AppImageConfig example example
 * ```
 */
public class AppImageConfig internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.AppImageConfig,
) : KotlinCustomResource(javaResource, AppImageConfigMapper) {
    /**
     * The name of the App Image Config.
     */
    public val appImageConfigName: Output<String>
        get() = javaResource.appImageConfigName().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this App Image Config.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The CodeEditorAppImageConfig. You can only specify one image kernel in the AppImageConfig API. This kernel is shown to users before the image starts. After the image runs, all kernels are visible in Code Editor. See Code Editor App Image Config details below.
     */
    public val codeEditorAppImageConfig: Output<AppImageConfigCodeEditorAppImageConfig>?
        get() = javaResource.codeEditorAppImageConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> appImageConfigCodeEditorAppImageConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The JupyterLabAppImageConfig. You can only specify one image kernel in the AppImageConfig API. This kernel is shown to users before the image starts. After the image runs, all kernels are visible in JupyterLab. See Jupyter Lab Image Config details below.
     */
    public val jupyterLabImageConfig: Output<AppImageConfigJupyterLabImageConfig>?
        get() = javaResource.jupyterLabImageConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> appImageConfigJupyterLabImageConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app. See Kernel Gateway Image Config details below.
     */
    public val kernelGatewayImageConfig: Output<AppImageConfigKernelGatewayImageConfig>?
        get() = javaResource.kernelGatewayImageConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> appImageConfigKernelGatewayImageConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object AppImageConfigMapper : ResourceMapper<AppImageConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.AppImageConfig::class == javaResource::class

    override fun map(javaResource: Resource): AppImageConfig = AppImageConfig(
        javaResource as
            com.pulumi.aws.sagemaker.AppImageConfig,
    )
}

/**
 * @see [AppImageConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AppImageConfig].
 */
public suspend fun appImageConfig(
    name: String,
    block: suspend AppImageConfigResourceBuilder.() -> Unit,
): AppImageConfig {
    val builder = AppImageConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AppImageConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun appImageConfig(name: String): AppImageConfig {
    val builder = AppImageConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
