@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.AppImageConfigArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.AppImageConfigCodeEditorAppImageConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.AppImageConfigCodeEditorAppImageConfigArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.AppImageConfigJupyterLabImageConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.AppImageConfigJupyterLabImageConfigArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.AppImageConfigKernelGatewayImageConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.AppImageConfigKernelGatewayImageConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker App Image Config resource.
 * ## Example Usage
 * ### Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.AppImageConfig;
 * import com.pulumi.aws.sagemaker.AppImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AppImageConfig("test", AppImageConfigArgs.builder()
 *             .appImageConfigName("example")
 *             .kernelGatewayImageConfig(AppImageConfigKernelGatewayImageConfigArgs.builder()
 *                 .kernelSpecs(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:sagemaker:AppImageConfig
 *     properties:
 *       appImageConfigName: example
 *       kernelGatewayImageConfig:
 *         kernelSpecs:
 *           - name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Default File System Config
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.AppImageConfig;
 * import com.pulumi.aws.sagemaker.AppImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigFileSystemConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AppImageConfig("test", AppImageConfigArgs.builder()
 *             .appImageConfigName("example")
 *             .kernelGatewayImageConfig(AppImageConfigKernelGatewayImageConfigArgs.builder()
 *                 .kernelSpecs(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .fileSystemConfig()
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:sagemaker:AppImageConfig
 *     properties:
 *       appImageConfigName: example
 *       kernelGatewayImageConfig:
 *         kernelSpecs:
 *           - name: example
 *         fileSystemConfig: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker App Image Configs using the `name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/appImageConfig:AppImageConfig example example
 * ```
 * @property appImageConfigName The name of the App Image Config.
 * @property codeEditorAppImageConfig The CodeEditorAppImageConfig. You can only specify one image kernel in the AppImageConfig API. This kernel is shown to users before the image starts. After the image runs, all kernels are visible in Code Editor. See Code Editor App Image Config details below.
 * @property jupyterLabImageConfig The JupyterLabAppImageConfig. You can only specify one image kernel in the AppImageConfig API. This kernel is shown to users before the image starts. After the image runs, all kernels are visible in JupyterLab. See Jupyter Lab Image Config details below.
 * @property kernelGatewayImageConfig The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app. See Kernel Gateway Image Config details below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AppImageConfigArgs(
    public val appImageConfigName: Output<String>? = null,
    public val codeEditorAppImageConfig: Output<AppImageConfigCodeEditorAppImageConfigArgs>? = null,
    public val jupyterLabImageConfig: Output<AppImageConfigJupyterLabImageConfigArgs>? = null,
    public val kernelGatewayImageConfig: Output<AppImageConfigKernelGatewayImageConfigArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.AppImageConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.AppImageConfigArgs =
        com.pulumi.aws.sagemaker.AppImageConfigArgs.builder()
            .appImageConfigName(appImageConfigName?.applyValue({ args0 -> args0 }))
            .codeEditorAppImageConfig(
                codeEditorAppImageConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .jupyterLabImageConfig(
                jupyterLabImageConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kernelGatewayImageConfig(
                kernelGatewayImageConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AppImageConfigArgs].
 */
@PulumiTagMarker
public class AppImageConfigArgsBuilder internal constructor() {
    private var appImageConfigName: Output<String>? = null

    private var codeEditorAppImageConfig: Output<AppImageConfigCodeEditorAppImageConfigArgs>? = null

    private var jupyterLabImageConfig: Output<AppImageConfigJupyterLabImageConfigArgs>? = null

    private var kernelGatewayImageConfig: Output<AppImageConfigKernelGatewayImageConfigArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the App Image Config.
     */
    @JvmName("eqyiuwadtosxxfsy")
    public suspend fun appImageConfigName(`value`: Output<String>) {
        this.appImageConfigName = value
    }

    /**
     * @param value The CodeEditorAppImageConfig. You can only specify one image kernel in the AppImageConfig API. This kernel is shown to users before the image starts. After the image runs, all kernels are visible in Code Editor. See Code Editor App Image Config details below.
     */
    @JvmName("utceeunjxkstjbdy")
    public suspend fun codeEditorAppImageConfig(`value`: Output<AppImageConfigCodeEditorAppImageConfigArgs>) {
        this.codeEditorAppImageConfig = value
    }

    /**
     * @param value The JupyterLabAppImageConfig. You can only specify one image kernel in the AppImageConfig API. This kernel is shown to users before the image starts. After the image runs, all kernels are visible in JupyterLab. See Jupyter Lab Image Config details below.
     */
    @JvmName("xvhcbhrtiwbpigbi")
    public suspend fun jupyterLabImageConfig(`value`: Output<AppImageConfigJupyterLabImageConfigArgs>) {
        this.jupyterLabImageConfig = value
    }

    /**
     * @param value The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app. See Kernel Gateway Image Config details below.
     */
    @JvmName("hhibrbaalqcxhhli")
    public suspend fun kernelGatewayImageConfig(`value`: Output<AppImageConfigKernelGatewayImageConfigArgs>) {
        this.kernelGatewayImageConfig = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bbkrbkympluptdvr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the App Image Config.
     */
    @JvmName("hyjvccfavxcscgdo")
    public suspend fun appImageConfigName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appImageConfigName = mapped
    }

    /**
     * @param value The CodeEditorAppImageConfig. You can only specify one image kernel in the AppImageConfig API. This kernel is shown to users before the image starts. After the image runs, all kernels are visible in Code Editor. See Code Editor App Image Config details below.
     */
    @JvmName("alhqamhgsemvkagq")
    public suspend fun codeEditorAppImageConfig(`value`: AppImageConfigCodeEditorAppImageConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeEditorAppImageConfig = mapped
    }

    /**
     * @param argument The CodeEditorAppImageConfig. You can only specify one image kernel in the AppImageConfig API. This kernel is shown to users before the image starts. After the image runs, all kernels are visible in Code Editor. See Code Editor App Image Config details below.
     */
    @JvmName("qaykmfsawujquihs")
    public suspend fun codeEditorAppImageConfig(argument: suspend AppImageConfigCodeEditorAppImageConfigArgsBuilder.() -> Unit) {
        val toBeMapped = AppImageConfigCodeEditorAppImageConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.codeEditorAppImageConfig = mapped
    }

    /**
     * @param value The JupyterLabAppImageConfig. You can only specify one image kernel in the AppImageConfig API. This kernel is shown to users before the image starts. After the image runs, all kernels are visible in JupyterLab. See Jupyter Lab Image Config details below.
     */
    @JvmName("utgoaepngafisajp")
    public suspend fun jupyterLabImageConfig(`value`: AppImageConfigJupyterLabImageConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jupyterLabImageConfig = mapped
    }

    /**
     * @param argument The JupyterLabAppImageConfig. You can only specify one image kernel in the AppImageConfig API. This kernel is shown to users before the image starts. After the image runs, all kernels are visible in JupyterLab. See Jupyter Lab Image Config details below.
     */
    @JvmName("lbkkwvpfiraokdsm")
    public suspend fun jupyterLabImageConfig(argument: suspend AppImageConfigJupyterLabImageConfigArgsBuilder.() -> Unit) {
        val toBeMapped = AppImageConfigJupyterLabImageConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.jupyterLabImageConfig = mapped
    }

    /**
     * @param value The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app. See Kernel Gateway Image Config details below.
     */
    @JvmName("ubdvxqkocedlovjg")
    public suspend fun kernelGatewayImageConfig(`value`: AppImageConfigKernelGatewayImageConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kernelGatewayImageConfig = mapped
    }

    /**
     * @param argument The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app. See Kernel Gateway Image Config details below.
     */
    @JvmName("xskvwawdwgolnllh")
    public suspend fun kernelGatewayImageConfig(argument: suspend AppImageConfigKernelGatewayImageConfigArgsBuilder.() -> Unit) {
        val toBeMapped = AppImageConfigKernelGatewayImageConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kernelGatewayImageConfig = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iaqgwuttpdhwdukf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ulrkcnojisvrdaga")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AppImageConfigArgs = AppImageConfigArgs(
        appImageConfigName = appImageConfigName,
        codeEditorAppImageConfig = codeEditorAppImageConfig,
        jupyterLabImageConfig = jupyterLabImageConfig,
        kernelGatewayImageConfig = kernelGatewayImageConfig,
        tags = tags,
    )
}
