@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.CodeRepositoryGitConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.CodeRepositoryGitConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [CodeRepository].
 */
@PulumiTagMarker
public class CodeRepositoryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CodeRepositoryArgs = CodeRepositoryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CodeRepositoryArgsBuilder.() -> Unit) {
        val builder = CodeRepositoryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CodeRepository {
        val builtJavaResource = com.pulumi.aws.sagemaker.CodeRepository(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CodeRepository(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Code Repository resource.
 * ## Example Usage
 * ### Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.CodeRepository("example", {
 *     codeRepositoryName: "example",
 *     gitConfig: {
 *         repositoryUrl: "https://github.com/github/docs.git",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.CodeRepository("example",
 *     code_repository_name="example",
 *     git_config={
 *         "repository_url": "https://github.com/github/docs.git",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.CodeRepository("example", new()
 *     {
 *         CodeRepositoryName = "example",
 *         GitConfig = new Aws.Sagemaker.Inputs.CodeRepositoryGitConfigArgs
 *         {
 *             RepositoryUrl = "https://github.com/github/docs.git",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewCodeRepository(ctx, "example", &sagemaker.CodeRepositoryArgs{
 * 			CodeRepositoryName: pulumi.String("example"),
 * 			GitConfig: &sagemaker.CodeRepositoryGitConfigArgs{
 * 				RepositoryUrl: pulumi.String("https://github.com/github/docs.git"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.CodeRepository;
 * import com.pulumi.aws.sagemaker.CodeRepositoryArgs;
 * import com.pulumi.aws.sagemaker.inputs.CodeRepositoryGitConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CodeRepository("example", CodeRepositoryArgs.builder()
 *             .codeRepositoryName("example")
 *             .gitConfig(CodeRepositoryGitConfigArgs.builder()
 *                 .repositoryUrl("https://github.com/github/docs.git")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:CodeRepository
 *     properties:
 *       codeRepositoryName: example
 *       gitConfig:
 *         repositoryUrl: https://github.com/github/docs.git
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example with Secret
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.secretsmanager.Secret("example", {name: "example"});
 * const exampleSecretVersion = new aws.secretsmanager.SecretVersion("example", {
 *     secretId: example.id,
 *     secretString: JSON.stringify({
 *         username: "example",
 *         password: "example",
 *     }),
 * });
 * const exampleCodeRepository = new aws.sagemaker.CodeRepository("example", {
 *     codeRepositoryName: "example",
 *     gitConfig: {
 *         repositoryUrl: "https://github.com/github/docs.git",
 *         secretArn: example.arn,
 *     },
 * }, {
 *     dependsOn: [exampleSecretVersion],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.secretsmanager.Secret("example", name="example")
 * example_secret_version = aws.secretsmanager.SecretVersion("example",
 *     secret_id=example.id,
 *     secret_string=json.dumps({
 *         "username": "example",
 *         "password": "example",
 *     }))
 * example_code_repository = aws.sagemaker.CodeRepository("example",
 *     code_repository_name="example",
 *     git_config={
 *         "repository_url": "https://github.com/github/docs.git",
 *         "secret_arn": example.arn,
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example_secret_version]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecretsManager.Secret("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var exampleSecretVersion = new Aws.SecretsManager.SecretVersion("example", new()
 *     {
 *         SecretId = example.Id,
 *         SecretString = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["username"] = "example",
 *             ["password"] = "example",
 *         }),
 *     });
 *     var exampleCodeRepository = new Aws.Sagemaker.CodeRepository("example", new()
 *     {
 *         CodeRepositoryName = "example",
 *         GitConfig = new Aws.Sagemaker.Inputs.CodeRepositoryGitConfigArgs
 *         {
 *             RepositoryUrl = "https://github.com/github/docs.git",
 *             SecretArn = example.Arn,
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleSecretVersion,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/secretsmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := secretsmanager.NewSecret(ctx, "example", &secretsmanager.SecretArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"username": "example",
 * 			"password": "example",
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		exampleSecretVersion, err := secretsmanager.NewSecretVersion(ctx, "example", &secretsmanager.SecretVersionArgs{
 * 			SecretId:     example.ID(),
 * 			SecretString: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sagemaker.NewCodeRepository(ctx, "example", &sagemaker.CodeRepositoryArgs{
 * 			CodeRepositoryName: pulumi.String("example"),
 * 			GitConfig: &sagemaker.CodeRepositoryGitConfigArgs{
 * 				RepositoryUrl: pulumi.String("https://github.com/github/docs.git"),
 * 				SecretArn:     example.Arn,
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleSecretVersion,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.secretsmanager.Secret;
 * import com.pulumi.aws.secretsmanager.SecretArgs;
 * import com.pulumi.aws.secretsmanager.SecretVersion;
 * import com.pulumi.aws.secretsmanager.SecretVersionArgs;
 * import com.pulumi.aws.sagemaker.CodeRepository;
 * import com.pulumi.aws.sagemaker.CodeRepositoryArgs;
 * import com.pulumi.aws.sagemaker.inputs.CodeRepositoryGitConfigArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Secret("example", SecretArgs.builder()
 *             .name("example")
 *             .build());
 *         var exampleSecretVersion = new SecretVersion("exampleSecretVersion", SecretVersionArgs.builder()
 *             .secretId(example.id())
 *             .secretString(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("username", "example"),
 *                     jsonProperty("password", "example")
 *                 )))
 *             .build());
 *         var exampleCodeRepository = new CodeRepository("exampleCodeRepository", CodeRepositoryArgs.builder()
 *             .codeRepositoryName("example")
 *             .gitConfig(CodeRepositoryGitConfigArgs.builder()
 *                 .repositoryUrl("https://github.com/github/docs.git")
 *                 .secretArn(example.arn())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleSecretVersion)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:secretsmanager:Secret
 *     properties:
 *       name: example
 *   exampleSecretVersion:
 *     type: aws:secretsmanager:SecretVersion
 *     name: example
 *     properties:
 *       secretId: ${example.id}
 *       secretString:
 *         fn::toJSON:
 *           username: example
 *           password: example
 *   exampleCodeRepository:
 *     type: aws:sagemaker:CodeRepository
 *     name: example
 *     properties:
 *       codeRepositoryName: example
 *       gitConfig:
 *         repositoryUrl: https://github.com/github/docs.git
 *         secretArn: ${example.arn}
 *     options:
 *       dependson:
 *         - ${exampleSecretVersion}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Code Repositories using the `name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/codeRepository:CodeRepository test_code_repository my-code-repo
 * ```
 */
public class CodeRepository internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.CodeRepository,
) : KotlinCustomResource(javaResource, CodeRepositoryMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Code Repository.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the Code Repository (must be unique).
     */
    public val codeRepositoryName: Output<String>
        get() = javaResource.codeRepositoryName().applyValue({ args0 -> args0 })

    /**
     * Specifies details about the repository. see Git Config details below.
     */
    public val gitConfig: Output<CodeRepositoryGitConfig>
        get() = javaResource.gitConfig().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object CodeRepositoryMapper : ResourceMapper<CodeRepository> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.CodeRepository::class == javaResource::class

    override fun map(javaResource: Resource): CodeRepository = CodeRepository(
        javaResource as
            com.pulumi.aws.sagemaker.CodeRepository,
    )
}

/**
 * @see [CodeRepository].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CodeRepository].
 */
public suspend fun codeRepository(
    name: String,
    block: suspend CodeRepositoryResourceBuilder.() -> Unit,
): CodeRepository {
    val builder = CodeRepositoryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CodeRepository].
 * @param name The _unique_ name of the resulting resource.
 */
public fun codeRepository(name: String): CodeRepository {
    val builder = CodeRepositoryResourceBuilder()
    builder.name(name)
    return builder.build()
}
