@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.CodeRepositoryArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.CodeRepositoryGitConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.CodeRepositoryGitConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Code Repository resource.
 * ## Example Usage
 * ### Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.CodeRepository("example", {
 *     codeRepositoryName: "example",
 *     gitConfig: {
 *         repositoryUrl: "https://github.com/github/docs.git",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.CodeRepository("example",
 *     code_repository_name="example",
 *     git_config={
 *         "repository_url": "https://github.com/github/docs.git",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.CodeRepository("example", new()
 *     {
 *         CodeRepositoryName = "example",
 *         GitConfig = new Aws.Sagemaker.Inputs.CodeRepositoryGitConfigArgs
 *         {
 *             RepositoryUrl = "https://github.com/github/docs.git",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewCodeRepository(ctx, "example", &sagemaker.CodeRepositoryArgs{
 * 			CodeRepositoryName: pulumi.String("example"),
 * 			GitConfig: &sagemaker.CodeRepositoryGitConfigArgs{
 * 				RepositoryUrl: pulumi.String("https://github.com/github/docs.git"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.CodeRepository;
 * import com.pulumi.aws.sagemaker.CodeRepositoryArgs;
 * import com.pulumi.aws.sagemaker.inputs.CodeRepositoryGitConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CodeRepository("example", CodeRepositoryArgs.builder()
 *             .codeRepositoryName("example")
 *             .gitConfig(CodeRepositoryGitConfigArgs.builder()
 *                 .repositoryUrl("https://github.com/github/docs.git")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:CodeRepository
 *     properties:
 *       codeRepositoryName: example
 *       gitConfig:
 *         repositoryUrl: https://github.com/github/docs.git
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example with Secret
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.secretsmanager.Secret("example", {name: "example"});
 * const exampleSecretVersion = new aws.secretsmanager.SecretVersion("example", {
 *     secretId: example.id,
 *     secretString: JSON.stringify({
 *         username: "example",
 *         password: "example",
 *     }),
 * });
 * const exampleCodeRepository = new aws.sagemaker.CodeRepository("example", {
 *     codeRepositoryName: "example",
 *     gitConfig: {
 *         repositoryUrl: "https://github.com/github/docs.git",
 *         secretArn: example.arn,
 *     },
 * }, {
 *     dependsOn: [exampleSecretVersion],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.secretsmanager.Secret("example", name="example")
 * example_secret_version = aws.secretsmanager.SecretVersion("example",
 *     secret_id=example.id,
 *     secret_string=json.dumps({
 *         "username": "example",
 *         "password": "example",
 *     }))
 * example_code_repository = aws.sagemaker.CodeRepository("example",
 *     code_repository_name="example",
 *     git_config={
 *         "repository_url": "https://github.com/github/docs.git",
 *         "secret_arn": example.arn,
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example_secret_version]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecretsManager.Secret("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var exampleSecretVersion = new Aws.SecretsManager.SecretVersion("example", new()
 *     {
 *         SecretId = example.Id,
 *         SecretString = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["username"] = "example",
 *             ["password"] = "example",
 *         }),
 *     });
 *     var exampleCodeRepository = new Aws.Sagemaker.CodeRepository("example", new()
 *     {
 *         CodeRepositoryName = "example",
 *         GitConfig = new Aws.Sagemaker.Inputs.CodeRepositoryGitConfigArgs
 *         {
 *             RepositoryUrl = "https://github.com/github/docs.git",
 *             SecretArn = example.Arn,
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleSecretVersion,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/secretsmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := secretsmanager.NewSecret(ctx, "example", &secretsmanager.SecretArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"username": "example",
 * 			"password": "example",
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		exampleSecretVersion, err := secretsmanager.NewSecretVersion(ctx, "example", &secretsmanager.SecretVersionArgs{
 * 			SecretId:     example.ID(),
 * 			SecretString: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sagemaker.NewCodeRepository(ctx, "example", &sagemaker.CodeRepositoryArgs{
 * 			CodeRepositoryName: pulumi.String("example"),
 * 			GitConfig: &sagemaker.CodeRepositoryGitConfigArgs{
 * 				RepositoryUrl: pulumi.String("https://github.com/github/docs.git"),
 * 				SecretArn:     example.Arn,
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleSecretVersion,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.secretsmanager.Secret;
 * import com.pulumi.aws.secretsmanager.SecretArgs;
 * import com.pulumi.aws.secretsmanager.SecretVersion;
 * import com.pulumi.aws.secretsmanager.SecretVersionArgs;
 * import com.pulumi.aws.sagemaker.CodeRepository;
 * import com.pulumi.aws.sagemaker.CodeRepositoryArgs;
 * import com.pulumi.aws.sagemaker.inputs.CodeRepositoryGitConfigArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Secret("example", SecretArgs.builder()
 *             .name("example")
 *             .build());
 *         var exampleSecretVersion = new SecretVersion("exampleSecretVersion", SecretVersionArgs.builder()
 *             .secretId(example.id())
 *             .secretString(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("username", "example"),
 *                     jsonProperty("password", "example")
 *                 )))
 *             .build());
 *         var exampleCodeRepository = new CodeRepository("exampleCodeRepository", CodeRepositoryArgs.builder()
 *             .codeRepositoryName("example")
 *             .gitConfig(CodeRepositoryGitConfigArgs.builder()
 *                 .repositoryUrl("https://github.com/github/docs.git")
 *                 .secretArn(example.arn())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleSecretVersion)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:secretsmanager:Secret
 *     properties:
 *       name: example
 *   exampleSecretVersion:
 *     type: aws:secretsmanager:SecretVersion
 *     name: example
 *     properties:
 *       secretId: ${example.id}
 *       secretString:
 *         fn::toJSON:
 *           username: example
 *           password: example
 *   exampleCodeRepository:
 *     type: aws:sagemaker:CodeRepository
 *     name: example
 *     properties:
 *       codeRepositoryName: example
 *       gitConfig:
 *         repositoryUrl: https://github.com/github/docs.git
 *         secretArn: ${example.arn}
 *     options:
 *       dependson:
 *         - ${exampleSecretVersion}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Code Repositories using the `name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/codeRepository:CodeRepository test_code_repository my-code-repo
 * ```
 * @property codeRepositoryName The name of the Code Repository (must be unique).
 * @property gitConfig Specifies details about the repository. see Git Config details below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CodeRepositoryArgs(
    public val codeRepositoryName: Output<String>? = null,
    public val gitConfig: Output<CodeRepositoryGitConfigArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.CodeRepositoryArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.CodeRepositoryArgs =
        com.pulumi.aws.sagemaker.CodeRepositoryArgs.builder()
            .codeRepositoryName(codeRepositoryName?.applyValue({ args0 -> args0 }))
            .gitConfig(gitConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CodeRepositoryArgs].
 */
@PulumiTagMarker
public class CodeRepositoryArgsBuilder internal constructor() {
    private var codeRepositoryName: Output<String>? = null

    private var gitConfig: Output<CodeRepositoryGitConfigArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Code Repository (must be unique).
     */
    @JvmName("dtjfwnqnikmmrmhd")
    public suspend fun codeRepositoryName(`value`: Output<String>) {
        this.codeRepositoryName = value
    }

    /**
     * @param value Specifies details about the repository. see Git Config details below.
     */
    @JvmName("plfhcykwyrkvdyoy")
    public suspend fun gitConfig(`value`: Output<CodeRepositoryGitConfigArgs>) {
        this.gitConfig = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kcdphetgiliwdmqr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Code Repository (must be unique).
     */
    @JvmName("iowtpmnxvjwuehcv")
    public suspend fun codeRepositoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeRepositoryName = mapped
    }

    /**
     * @param value Specifies details about the repository. see Git Config details below.
     */
    @JvmName("bnktbuqvyufwaaxq")
    public suspend fun gitConfig(`value`: CodeRepositoryGitConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitConfig = mapped
    }

    /**
     * @param argument Specifies details about the repository. see Git Config details below.
     */
    @JvmName("bwchsggdnjnkrxke")
    public suspend fun gitConfig(argument: suspend CodeRepositoryGitConfigArgsBuilder.() -> Unit) {
        val toBeMapped = CodeRepositoryGitConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gitConfig = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tagimhthismdrhff")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("crvfbguckptqkfcc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CodeRepositoryArgs = CodeRepositoryArgs(
        codeRepositoryName = codeRepositoryName,
        gitConfig = gitConfig,
        tags = tags,
    )
}
