@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.DataQualityJobDefinitionArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.DataQualityJobDefinitionDataQualityAppSpecificationArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.DataQualityJobDefinitionDataQualityAppSpecificationArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.DataQualityJobDefinitionDataQualityBaselineConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.DataQualityJobDefinitionDataQualityBaselineConfigArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.DataQualityJobDefinitionDataQualityJobInputArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.DataQualityJobDefinitionDataQualityJobInputArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.DataQualityJobDefinitionJobResourcesArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.DataQualityJobDefinitionJobResourcesArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.DataQualityJobDefinitionNetworkConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.DataQualityJobDefinitionNetworkConfigArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.DataQualityJobDefinitionStoppingConditionArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.DataQualityJobDefinitionStoppingConditionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker data quality job definition resource.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.sagemaker.DataQualityJobDefinition("test", {
 *     name: "my-data-quality-job-definition",
 *     dataQualityAppSpecification: {
 *         imageUri: monitor.registryPath,
 *     },
 *     dataQualityJobInput: {
 *         endpointInput: {
 *             endpointName: myEndpoint.name,
 *         },
 *     },
 *     dataQualityJobOutputConfig: {
 *         monitoringOutputs: {
 *             s3Output: {
 *                 s3Uri: `https://${myBucket.bucketRegionalDomainName}/output`,
 *             },
 *         },
 *     },
 *     jobResources: {
 *         clusterConfig: {
 *             instanceCount: 1,
 *             instanceType: "ml.t3.medium",
 *             volumeSizeInGb: 20,
 *         },
 *     },
 *     roleArn: myRole.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.sagemaker.DataQualityJobDefinition("test",
 *     name="my-data-quality-job-definition",
 *     data_quality_app_specification={
 *         "image_uri": monitor["registryPath"],
 *     },
 *     data_quality_job_input={
 *         "endpoint_input": {
 *             "endpoint_name": my_endpoint["name"],
 *         },
 *     },
 *     data_quality_job_output_config={
 *         "monitoring_outputs": {
 *             "s3_output": {
 *                 "s3_uri": f"https://{my_bucket['bucketRegionalDomainName']}/output",
 *             },
 *         },
 *     },
 *     job_resources={
 *         "cluster_config": {
 *             "instance_count": 1,
 *             "instance_type": "ml.t3.medium",
 *             "volume_size_in_gb": 20,
 *         },
 *     },
 *     role_arn=my_role["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Sagemaker.DataQualityJobDefinition("test", new()
 *     {
 *         Name = "my-data-quality-job-definition",
 *         DataQualityAppSpecification = new Aws.Sagemaker.Inputs.DataQualityJobDefinitionDataQualityAppSpecificationArgs
 *         {
 *             ImageUri = monitor.RegistryPath,
 *         },
 *         DataQualityJobInput = new Aws.Sagemaker.Inputs.DataQualityJobDefinitionDataQualityJobInputArgs
 *         {
 *             EndpointInput = new Aws.Sagemaker.Inputs.DataQualityJobDefinitionDataQualityJobInputEndpointInputArgs
 *             {
 *                 EndpointName = myEndpoint.Name,
 *             },
 *         },
 *         DataQualityJobOutputConfig = new Aws.Sagemaker.Inputs.DataQualityJobDefinitionDataQualityJobOutputConfigArgs
 *         {
 *             MonitoringOutputs = new Aws.Sagemaker.Inputs.DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgs
 *             {
 *                 S3Output = new Aws.Sagemaker.Inputs.DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgs
 *                 {
 *                     S3Uri = $"https://{myBucket.BucketRegionalDomainName}/output",
 *                 },
 *             },
 *         },
 *         JobResources = new Aws.Sagemaker.Inputs.DataQualityJobDefinitionJobResourcesArgs
 *         {
 *             ClusterConfig = new Aws.Sagemaker.Inputs.DataQualityJobDefinitionJobResourcesClusterConfigArgs
 *             {
 *                 InstanceCount = 1,
 *                 InstanceType = "ml.t3.medium",
 *                 VolumeSizeInGb = 20,
 *             },
 *         },
 *         RoleArn = myRole.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewDataQualityJobDefinition(ctx, "test", &sagemaker.DataQualityJobDefinitionArgs{
 * 			Name: pulumi.String("my-data-quality-job-definition"),
 * 			DataQualityAppSpecification: &sagemaker.DataQualityJobDefinitionDataQualityAppSpecificationArgs{
 * 				ImageUri: pulumi.Any(monitor.RegistryPath),
 * 			},
 * 			DataQualityJobInput: &sagemaker.DataQualityJobDefinitionDataQualityJobInputArgs{
 * 				EndpointInput: &sagemaker.DataQualityJobDefinitionDataQualityJobInputEndpointInputArgs{
 * 					EndpointName: pulumi.Any(myEndpoint.Name),
 * 				},
 * 			},
 * 			DataQualityJobOutputConfig: &sagemaker.DataQualityJobDefinitionDataQualityJobOutputConfigArgs{
 * 				MonitoringOutputs: &sagemaker.DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgs{
 * 					S3Output: sagemaker.DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgs{
 * 						S3Uri: pulumi.Sprintf("https://%v/output", myBucket.BucketRegionalDomainName),
 * 					},
 * 				},
 * 			},
 * 			JobResources: &sagemaker.DataQualityJobDefinitionJobResourcesArgs{
 * 				ClusterConfig: &sagemaker.DataQualityJobDefinitionJobResourcesClusterConfigArgs{
 * 					InstanceCount:  pulumi.Int(1),
 * 					InstanceType:   pulumi.String("ml.t3.medium"),
 * 					VolumeSizeInGb: pulumi.Int(20),
 * 				},
 * 			},
 * 			RoleArn: pulumi.Any(myRole.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.DataQualityJobDefinition;
 * import com.pulumi.aws.sagemaker.DataQualityJobDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityAppSpecificationArgs;
 * import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputArgs;
 * import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputEndpointInputArgs;
 * import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgs;
 * import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgs;
 * import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionJobResourcesArgs;
 * import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionJobResourcesClusterConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new DataQualityJobDefinition("test", DataQualityJobDefinitionArgs.builder()
 *             .name("my-data-quality-job-definition")
 *             .dataQualityAppSpecification(DataQualityJobDefinitionDataQualityAppSpecificationArgs.builder()
 *                 .imageUri(monitor.registryPath())
 *                 .build())
 *             .dataQualityJobInput(DataQualityJobDefinitionDataQualityJobInputArgs.builder()
 *                 .endpointInput(DataQualityJobDefinitionDataQualityJobInputEndpointInputArgs.builder()
 *                     .endpointName(myEndpoint.name())
 *                     .build())
 *                 .build())
 *             .dataQualityJobOutputConfig(DataQualityJobDefinitionDataQualityJobOutputConfigArgs.builder()
 *                 .monitoringOutputs(DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgs.builder()
 *                     .s3Output(DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgs.builder()
 *                         .s3Uri(String.format("https://%s/output", myBucket.bucketRegionalDomainName()))
 *                         .build())
 *                     .build())
 *                 .build())
 *             .jobResources(DataQualityJobDefinitionJobResourcesArgs.builder()
 *                 .clusterConfig(DataQualityJobDefinitionJobResourcesClusterConfigArgs.builder()
 *                     .instanceCount(1)
 *                     .instanceType("ml.t3.medium")
 *                     .volumeSizeInGb(20)
 *                     .build())
 *                 .build())
 *             .roleArn(myRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:sagemaker:DataQualityJobDefinition
 *     properties:
 *       name: my-data-quality-job-definition
 *       dataQualityAppSpecification:
 *         imageUri: ${monitor.registryPath}
 *       dataQualityJobInput:
 *         endpointInput:
 *           endpointName: ${myEndpoint.name}
 *       dataQualityJobOutputConfig:
 *         monitoringOutputs:
 *           s3Output:
 *             s3Uri: https://${myBucket.bucketRegionalDomainName}/output
 *       jobResources:
 *         clusterConfig:
 *           instanceCount: 1
 *           instanceType: ml.t3.medium
 *           volumeSizeInGb: 20
 *       roleArn: ${myRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import data quality job definitions using the `name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/dataQualityJobDefinition:DataQualityJobDefinition test_data_quality_job_definition data-quality-job-definition-foo
 * ```
 * @property dataQualityAppSpecification Specifies the container that runs the monitoring job. Fields are documented below.
 * @property dataQualityBaselineConfig Configures the constraints and baselines for the monitoring job. Fields are documented below.
 * @property dataQualityJobInput A list of inputs for the monitoring job. Fields are documented below.
 * @property dataQualityJobOutputConfig The output configuration for monitoring jobs. Fields are documented below.
 * @property jobResources Identifies the resources to deploy for a monitoring job. Fields are documented below.
 * @property name The name of the data quality job definition. If omitted, the provider will assign a random, unique name.
 * @property networkConfig Specifies networking configuration for the monitoring job. Fields are documented below.
 * @property roleArn The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
 * @property stoppingCondition A time limit for how long the monitoring job is allowed to run before stopping. Fields are documented below.
 * @property tags A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DataQualityJobDefinitionArgs(
    public val dataQualityAppSpecification: Output<DataQualityJobDefinitionDataQualityAppSpecificationArgs>? = null,
    public val dataQualityBaselineConfig: Output<DataQualityJobDefinitionDataQualityBaselineConfigArgs>? = null,
    public val dataQualityJobInput: Output<DataQualityJobDefinitionDataQualityJobInputArgs>? = null,
    public val dataQualityJobOutputConfig: Output<DataQualityJobDefinitionDataQualityJobOutputConfigArgs>? = null,
    public val jobResources: Output<DataQualityJobDefinitionJobResourcesArgs>? = null,
    public val name: Output<String>? = null,
    public val networkConfig: Output<DataQualityJobDefinitionNetworkConfigArgs>? = null,
    public val roleArn: Output<String>? = null,
    public val stoppingCondition: Output<DataQualityJobDefinitionStoppingConditionArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.DataQualityJobDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.DataQualityJobDefinitionArgs =
        com.pulumi.aws.sagemaker.DataQualityJobDefinitionArgs.builder()
            .dataQualityAppSpecification(
                dataQualityAppSpecification?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dataQualityBaselineConfig(
                dataQualityBaselineConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dataQualityJobInput(
                dataQualityJobInput?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dataQualityJobOutputConfig(
                dataQualityJobOutputConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .jobResources(jobResources?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkConfig(networkConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .stoppingCondition(stoppingCondition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DataQualityJobDefinitionArgs].
 */
@PulumiTagMarker
public class DataQualityJobDefinitionArgsBuilder internal constructor() {
    private var dataQualityAppSpecification:
        Output<DataQualityJobDefinitionDataQualityAppSpecificationArgs>? = null

    private var dataQualityBaselineConfig:
        Output<DataQualityJobDefinitionDataQualityBaselineConfigArgs>? = null

    private var dataQualityJobInput: Output<DataQualityJobDefinitionDataQualityJobInputArgs>? = null

    private var dataQualityJobOutputConfig:
        Output<DataQualityJobDefinitionDataQualityJobOutputConfigArgs>? = null

    private var jobResources: Output<DataQualityJobDefinitionJobResourcesArgs>? = null

    private var name: Output<String>? = null

    private var networkConfig: Output<DataQualityJobDefinitionNetworkConfigArgs>? = null

    private var roleArn: Output<String>? = null

    private var stoppingCondition: Output<DataQualityJobDefinitionStoppingConditionArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the container that runs the monitoring job. Fields are documented below.
     */
    @JvmName("vmedxpuueuecrbxi")
    public suspend fun dataQualityAppSpecification(`value`: Output<DataQualityJobDefinitionDataQualityAppSpecificationArgs>) {
        this.dataQualityAppSpecification = value
    }

    /**
     * @param value Configures the constraints and baselines for the monitoring job. Fields are documented below.
     */
    @JvmName("kstalejihxwynmre")
    public suspend fun dataQualityBaselineConfig(`value`: Output<DataQualityJobDefinitionDataQualityBaselineConfigArgs>) {
        this.dataQualityBaselineConfig = value
    }

    /**
     * @param value A list of inputs for the monitoring job. Fields are documented below.
     */
    @JvmName("byhywusvfbqdunkj")
    public suspend fun dataQualityJobInput(`value`: Output<DataQualityJobDefinitionDataQualityJobInputArgs>) {
        this.dataQualityJobInput = value
    }

    /**
     * @param value The output configuration for monitoring jobs. Fields are documented below.
     */
    @JvmName("prwrvnsrdudcjjqn")
    public suspend fun dataQualityJobOutputConfig(`value`: Output<DataQualityJobDefinitionDataQualityJobOutputConfigArgs>) {
        this.dataQualityJobOutputConfig = value
    }

    /**
     * @param value Identifies the resources to deploy for a monitoring job. Fields are documented below.
     */
    @JvmName("vphaypjijasosyvk")
    public suspend fun jobResources(`value`: Output<DataQualityJobDefinitionJobResourcesArgs>) {
        this.jobResources = value
    }

    /**
     * @param value The name of the data quality job definition. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("ghkkehfisvmsjxit")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies networking configuration for the monitoring job. Fields are documented below.
     */
    @JvmName("nuibibtlheuyfcoj")
    public suspend fun networkConfig(`value`: Output<DataQualityJobDefinitionNetworkConfigArgs>) {
        this.networkConfig = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     */
    @JvmName("mcuvllmiirphbpee")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value A time limit for how long the monitoring job is allowed to run before stopping. Fields are documented below.
     */
    @JvmName("yidbuytpbkxvvkjv")
    public suspend fun stoppingCondition(`value`: Output<DataQualityJobDefinitionStoppingConditionArgs>) {
        this.stoppingCondition = value
    }

    /**
     * @param value A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rkeywebwalevgeab")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the container that runs the monitoring job. Fields are documented below.
     */
    @JvmName("fuihihjxwfcvlleb")
    public suspend fun dataQualityAppSpecification(`value`: DataQualityJobDefinitionDataQualityAppSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataQualityAppSpecification = mapped
    }

    /**
     * @param argument Specifies the container that runs the monitoring job. Fields are documented below.
     */
    @JvmName("spnlokkowmqplbbq")
    public suspend fun dataQualityAppSpecification(argument: suspend DataQualityJobDefinitionDataQualityAppSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = DataQualityJobDefinitionDataQualityAppSpecificationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataQualityAppSpecification = mapped
    }

    /**
     * @param value Configures the constraints and baselines for the monitoring job. Fields are documented below.
     */
    @JvmName("gbwahprfdqxjisud")
    public suspend fun dataQualityBaselineConfig(`value`: DataQualityJobDefinitionDataQualityBaselineConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataQualityBaselineConfig = mapped
    }

    /**
     * @param argument Configures the constraints and baselines for the monitoring job. Fields are documented below.
     */
    @JvmName("dhnfygoxncqufqaj")
    public suspend fun dataQualityBaselineConfig(argument: suspend DataQualityJobDefinitionDataQualityBaselineConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataQualityJobDefinitionDataQualityBaselineConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataQualityBaselineConfig = mapped
    }

    /**
     * @param value A list of inputs for the monitoring job. Fields are documented below.
     */
    @JvmName("asmpkgsgnislgxqq")
    public suspend fun dataQualityJobInput(`value`: DataQualityJobDefinitionDataQualityJobInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataQualityJobInput = mapped
    }

    /**
     * @param argument A list of inputs for the monitoring job. Fields are documented below.
     */
    @JvmName("tqdeurhmtcuuisqu")
    public suspend fun dataQualityJobInput(argument: suspend DataQualityJobDefinitionDataQualityJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = DataQualityJobDefinitionDataQualityJobInputArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataQualityJobInput = mapped
    }

    /**
     * @param value The output configuration for monitoring jobs. Fields are documented below.
     */
    @JvmName("vxdhivnxuaxdntni")
    public suspend fun dataQualityJobOutputConfig(`value`: DataQualityJobDefinitionDataQualityJobOutputConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataQualityJobOutputConfig = mapped
    }

    /**
     * @param argument The output configuration for monitoring jobs. Fields are documented below.
     */
    @JvmName("cppramvseheuwige")
    public suspend fun dataQualityJobOutputConfig(argument: suspend DataQualityJobDefinitionDataQualityJobOutputConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataQualityJobDefinitionDataQualityJobOutputConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataQualityJobOutputConfig = mapped
    }

    /**
     * @param value Identifies the resources to deploy for a monitoring job. Fields are documented below.
     */
    @JvmName("hhfjtypnrcghvbmy")
    public suspend fun jobResources(`value`: DataQualityJobDefinitionJobResourcesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobResources = mapped
    }

    /**
     * @param argument Identifies the resources to deploy for a monitoring job. Fields are documented below.
     */
    @JvmName("lmjblfrtpcenqauk")
    public suspend fun jobResources(argument: suspend DataQualityJobDefinitionJobResourcesArgsBuilder.() -> Unit) {
        val toBeMapped = DataQualityJobDefinitionJobResourcesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.jobResources = mapped
    }

    /**
     * @param value The name of the data quality job definition. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("ookvtihubnurkwqi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies networking configuration for the monitoring job. Fields are documented below.
     */
    @JvmName("sojktdwmhixmmomg")
    public suspend fun networkConfig(`value`: DataQualityJobDefinitionNetworkConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkConfig = mapped
    }

    /**
     * @param argument Specifies networking configuration for the monitoring job. Fields are documented below.
     */
    @JvmName("lhgxctvoufwpatmo")
    public suspend fun networkConfig(argument: suspend DataQualityJobDefinitionNetworkConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataQualityJobDefinitionNetworkConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.networkConfig = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     */
    @JvmName("nrdysxsaycvxwnsi")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value A time limit for how long the monitoring job is allowed to run before stopping. Fields are documented below.
     */
    @JvmName("gmoxatwicqwnyyis")
    public suspend fun stoppingCondition(`value`: DataQualityJobDefinitionStoppingConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stoppingCondition = mapped
    }

    /**
     * @param argument A time limit for how long the monitoring job is allowed to run before stopping. Fields are documented below.
     */
    @JvmName("xmwxylqdtsybeqce")
    public suspend fun stoppingCondition(argument: suspend DataQualityJobDefinitionStoppingConditionArgsBuilder.() -> Unit) {
        val toBeMapped = DataQualityJobDefinitionStoppingConditionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.stoppingCondition = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qccwwtuvbrfgvqnn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jbyqrwiurvstodvh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DataQualityJobDefinitionArgs = DataQualityJobDefinitionArgs(
        dataQualityAppSpecification = dataQualityAppSpecification,
        dataQualityBaselineConfig = dataQualityBaselineConfig,
        dataQualityJobInput = dataQualityJobInput,
        dataQualityJobOutputConfig = dataQualityJobOutputConfig,
        jobResources = jobResources,
        name = name,
        networkConfig = networkConfig,
        roleArn = roleArn,
        stoppingCondition = stoppingCondition,
        tags = tags,
    )
}
