@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.DeviceArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.DeviceDeviceArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.DeviceDeviceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Device resource.
 * ## Example Usage
 * ### Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.Device("example", {
 *     deviceFleetName: exampleAwsSagemakerDeviceFleet.deviceFleetName,
 *     device: {
 *         deviceName: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.Device("example",
 *     device_fleet_name=example_aws_sagemaker_device_fleet["deviceFleetName"],
 *     device={
 *         "device_name": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.Device("example", new()
 *     {
 *         DeviceFleetName = exampleAwsSagemakerDeviceFleet.DeviceFleetName,
 *         DeviceDetails = new Aws.Sagemaker.Inputs.DeviceDeviceArgs
 *         {
 *             DeviceName = "example",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewDevice(ctx, "example", &sagemaker.DeviceArgs{
 * 			DeviceFleetName: pulumi.Any(exampleAwsSagemakerDeviceFleet.DeviceFleetName),
 * 			Device: &sagemaker.DeviceDeviceArgs{
 * 				DeviceName: pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Device;
 * import com.pulumi.aws.sagemaker.DeviceArgs;
 * import com.pulumi.aws.sagemaker.inputs.DeviceDeviceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Device("example", DeviceArgs.builder()
 *             .deviceFleetName(exampleAwsSagemakerDeviceFleet.deviceFleetName())
 *             .device(DeviceDeviceArgs.builder()
 *                 .deviceName("example")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:Device
 *     properties:
 *       deviceFleetName: ${exampleAwsSagemakerDeviceFleet.deviceFleetName}
 *       device:
 *         deviceName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Devices using the `device-fleet-name/device-name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/device:Device example my-fleet/my-device
 * ```
 * @property device The device to register with SageMaker Edge Manager. See Device details below.
 * @property deviceFleetName The name of the Device Fleet.
 */
public data class DeviceArgs(
    public val device: Output<DeviceDeviceArgs>? = null,
    public val deviceFleetName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.DeviceArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.DeviceArgs =
        com.pulumi.aws.sagemaker.DeviceArgs.builder()
            .device(device?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deviceFleetName(deviceFleetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeviceArgs].
 */
@PulumiTagMarker
public class DeviceArgsBuilder internal constructor() {
    private var device: Output<DeviceDeviceArgs>? = null

    private var deviceFleetName: Output<String>? = null

    /**
     * @param value The device to register with SageMaker Edge Manager. See Device details below.
     */
    @JvmName("gycifdxthngiseye")
    public suspend fun device(`value`: Output<DeviceDeviceArgs>) {
        this.device = value
    }

    /**
     * @param value The name of the Device Fleet.
     */
    @JvmName("kybxuijurlvyvpud")
    public suspend fun deviceFleetName(`value`: Output<String>) {
        this.deviceFleetName = value
    }

    /**
     * @param value The device to register with SageMaker Edge Manager. See Device details below.
     */
    @JvmName("byelalxbantnsxmh")
    public suspend fun device(`value`: DeviceDeviceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.device = mapped
    }

    /**
     * @param argument The device to register with SageMaker Edge Manager. See Device details below.
     */
    @JvmName("ctmmadoaywclqucd")
    public suspend fun device(argument: suspend DeviceDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = DeviceDeviceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.device = mapped
    }

    /**
     * @param value The name of the Device Fleet.
     */
    @JvmName("cvesrnrfvycgditx")
    public suspend fun deviceFleetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceFleetName = mapped
    }

    internal fun build(): DeviceArgs = DeviceArgs(
        device = device,
        deviceFleetName = deviceFleetName,
    )
}
