@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.DeviceFleetOutputConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.DeviceFleetOutputConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DeviceFleet].
 */
@PulumiTagMarker
public class DeviceFleetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeviceFleetArgs = DeviceFleetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeviceFleetArgsBuilder.() -> Unit) {
        val builder = DeviceFleetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DeviceFleet {
        val builtJavaResource = com.pulumi.aws.sagemaker.DeviceFleet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DeviceFleet(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Device Fleet resource.
 * ## Example Usage
 * ### Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.DeviceFleet("example", {
 *     deviceFleetName: "example",
 *     roleArn: test.arn,
 *     outputConfig: {
 *         s3OutputLocation: `s3://${exampleAwsS3Bucket.bucket}/prefix/`,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.DeviceFleet("example",
 *     device_fleet_name="example",
 *     role_arn=test["arn"],
 *     output_config={
 *         "s3_output_location": f"s3://{example_aws_s3_bucket['bucket']}/prefix/",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.DeviceFleet("example", new()
 *     {
 *         DeviceFleetName = "example",
 *         RoleArn = test.Arn,
 *         OutputConfig = new Aws.Sagemaker.Inputs.DeviceFleetOutputConfigArgs
 *         {
 *             S3OutputLocation = $"s3://{exampleAwsS3Bucket.Bucket}/prefix/",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewDeviceFleet(ctx, "example", &sagemaker.DeviceFleetArgs{
 * 			DeviceFleetName: pulumi.String("example"),
 * 			RoleArn:         pulumi.Any(test.Arn),
 * 			OutputConfig: &sagemaker.DeviceFleetOutputConfigArgs{
 * 				S3OutputLocation: pulumi.Sprintf("s3://%v/prefix/", exampleAwsS3Bucket.Bucket),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.DeviceFleet;
 * import com.pulumi.aws.sagemaker.DeviceFleetArgs;
 * import com.pulumi.aws.sagemaker.inputs.DeviceFleetOutputConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DeviceFleet("example", DeviceFleetArgs.builder()
 *             .deviceFleetName("example")
 *             .roleArn(test.arn())
 *             .outputConfig(DeviceFleetOutputConfigArgs.builder()
 *                 .s3OutputLocation(String.format("s3://%s/prefix/", exampleAwsS3Bucket.bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:DeviceFleet
 *     properties:
 *       deviceFleetName: example
 *       roleArn: ${test.arn}
 *       outputConfig:
 *         s3OutputLocation: s3://${exampleAwsS3Bucket.bucket}/prefix/
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Device Fleets using the `name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/deviceFleet:DeviceFleet example my-fleet
 * ```
 */
public class DeviceFleet internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.DeviceFleet,
) : KotlinCustomResource(javaResource, DeviceFleetMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Device Fleet.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A description of the fleet.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Device Fleet (must be unique).
     */
    public val deviceFleetName: Output<String>
        get() = javaResource.deviceFleetName().applyValue({ args0 -> args0 })

    /**
     * Whether to create an AWS IoT Role Alias during device fleet creation. The name of the role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".
     */
    public val enableIotRoleAlias: Output<Boolean>?
        get() = javaResource.enableIotRoleAlias().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val iotRoleAlias: Output<String>
        get() = javaResource.iotRoleAlias().applyValue({ args0 -> args0 })

    /**
     * Specifies details about the repository. see Output Config details below.
     */
    public val outputConfig: Output<DeviceFleetOutputConfig>
        get() = javaResource.outputConfig().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DeviceFleetMapper : ResourceMapper<DeviceFleet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.DeviceFleet::class == javaResource::class

    override fun map(javaResource: Resource): DeviceFleet = DeviceFleet(
        javaResource as
            com.pulumi.aws.sagemaker.DeviceFleet,
    )
}

/**
 * @see [DeviceFleet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DeviceFleet].
 */
public suspend fun deviceFleet(name: String, block: suspend DeviceFleetResourceBuilder.() -> Unit): DeviceFleet {
    val builder = DeviceFleetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DeviceFleet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deviceFleet(name: String): DeviceFleet {
    val builder = DeviceFleetResourceBuilder()
    builder.name(name)
    return builder.build()
}
