@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultSpaceSettings
import com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettings
import com.pulumi.aws.sagemaker.kotlin.outputs.DomainDomainSettings
import com.pulumi.aws.sagemaker.kotlin.outputs.DomainRetentionPolicy
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultSpaceSettings.Companion.toKotlin as domainDefaultSpaceSettingsToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettings.Companion.toKotlin as domainDefaultUserSettingsToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.DomainDomainSettings.Companion.toKotlin as domainDomainSettingsToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.DomainRetentionPolicy.Companion.toKotlin as domainRetentionPolicyToKotlin

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource = com.pulumi.aws.sagemaker.Domain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Domain(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Domain resource.
 * ## Example Usage
 * ### Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["sts:AssumeRole"],
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["sagemaker&#46;amazonaws&#46;com"],
 *         }],
 *     }],
 * });
 * const exampleRole = new aws.iam.Role("example", {
 *     name: "example",
 *     path: "/",
 *     assumeRolePolicy: example.then(example => example.json),
 * });
 * const exampleDomain = new aws.sagemaker.Domain("example", {
 *     domainName: "example",
 *     authMode: "IAM",
 *     vpcId: exampleAwsVpc.id,
 *     subnetIds: [exampleAwsSubnet&#46;id],
 *     defaultUserSettings: {
 *         executionRole: exampleRole.arn,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iam.get_policy_document(statements=[{
 *     "actions": ["sts:AssumeRole"],
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["sagemaker&#46;amazonaws&#46;com"],
 *     }],
 * }])
 * example_role = aws.iam.Role("example",
 *     name="example",
 *     path="/",
 *     assume_role_policy=example.json)
 * example_domain = aws.sagemaker.Domain("example",
 *     domain_name="example",
 *     auth_mode="IAM",
 *     vpc_id=example_aws_vpc["id"],
 *     subnet_ids=[example_aws_subnet["id"]],
 *     default_user_settings={
 *         "execution_role": example_role.arn,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "sagemaker.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRole = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "example",
 *         Path = "/",
 *         AssumeRolePolicy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var exampleDomain = new Aws.Sagemaker.Domain("example", new()
 *     {
 *         DomainName = "example",
 *         AuthMode = "IAM",
 *         VpcId = exampleAwsVpc.Id,
 *         SubnetIds = new[]
 *         {
 *             exampleAwsSubnet.Id,
 *         },
 *         DefaultUserSettings = new Aws.Sagemaker.Inputs.DomainDefaultUserSettingsArgs
 *         {
 *             ExecutionRole = exampleRole.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"sagemaker.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRole, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:             pulumi.String("example"),
 * 			Path:             pulumi.String("/"),
 * 			AssumeRolePolicy: pulumi.String(example.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sagemaker.NewDomain(ctx, "example", &sagemaker.DomainArgs{
 * 			DomainName: pulumi.String("example"),
 * 			AuthMode:   pulumi.String("IAM"),
 * 			VpcId:      pulumi.Any(exampleAwsVpc.Id),
 * 			SubnetIds: pulumi.StringArray{
 * 				exampleAwsSubnet.Id,
 * 			},
 * 			DefaultUserSettings: &sagemaker.DomainDefaultUserSettingsArgs{
 * 				ExecutionRole: exampleRole.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.sagemaker.Domain;
 * import com.pulumi.aws.sagemaker.DomainArgs;
 * import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("sagemaker.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .name("example")
 *             .path("/")
 *             .assumeRolePolicy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .domainName("example")
 *             .authMode("IAM")
 *             .vpcId(exampleAwsVpc.id())
 *             .subnetIds(exampleAwsSubnet.id())
 *             .defaultUserSettings(DomainDefaultUserSettingsArgs.builder()
 *                 .executionRole(exampleRole.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleDomain:
 *     type: aws:sagemaker:Domain
 *     name: example
 *     properties:
 *       domainName: example
 *       authMode: IAM
 *       vpcId: ${exampleAwsVpc.id}
 *       subnetIds:
 *         - ${exampleAwsSubnet.id}
 *       defaultUserSettings:
 *         executionRole: ${exampleRole.arn}
 *   exampleRole:
 *     type: aws:iam:Role
 *     name: example
 *     properties:
 *       name: example
 *       path: /
 *       assumeRolePolicy: ${example.json}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - sts:AssumeRole
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - sagemaker.amazonaws.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Using Custom Images
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Image;
 * import com.pulumi.aws.sagemaker.ImageArgs;
 * import com.pulumi.aws.sagemaker.AppImageConfig;
 * import com.pulumi.aws.sagemaker.AppImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigArgs;
 * import com.pulumi.aws.sagemaker.ImageVersion;
 * import com.pulumi.aws.sagemaker.ImageVersionArgs;
 * import com.pulumi.aws.sagemaker.Domain;
 * import com.pulumi.aws.sagemaker.DomainArgs;
 * import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsArgs;
 * import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsKernelGatewayAppSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Image("example", ImageArgs.builder()
 *             .imageName("example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .build());
 *         var exampleAppImageConfig = new AppImageConfig("exampleAppImageConfig", AppImageConfigArgs.builder()
 *             .appImageConfigName("example")
 *             .kernelGatewayImageConfig(AppImageConfigKernelGatewayImageConfigArgs.builder()
 *                 .kernelSpecs(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .build())
 *             .build());
 *         var exampleImageVersion = new ImageVersion("exampleImageVersion", ImageVersionArgs.builder()
 *             .imageName(example.id())
 *             .baseImage("base-image")
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .domainName("example")
 *             .authMode("IAM")
 *             .vpcId(exampleAwsVpc.id())
 *             .subnetIds(exampleAwsSubnet.id())
 *             .defaultUserSettings(DomainDefaultUserSettingsArgs.builder()
 *                 .executionRole(exampleAwsIamRole.arn())
 *                 .kernelGatewayAppSettings(DomainDefaultUserSettingsKernelGatewayAppSettingsArgs.builder()
 *                     .customImages(DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgs.builder()
 *                         .appImageConfigName(exampleAppImageConfig.appImageConfigName())
 *                         .imageName(exampleImageVersion.imageName())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:Image
 *     properties:
 *       imageName: example
 *       roleArn: ${exampleAwsIamRole.arn}
 *   exampleAppImageConfig:
 *     type: aws:sagemaker:AppImageConfig
 *     name: example
 *     properties:
 *       appImageConfigName: example
 *       kernelGatewayImageConfig:
 *         kernelSpecs:
 *           - name: example
 *   exampleImageVersion:
 *     type: aws:sagemaker:ImageVersion
 *     name: example
 *     properties:
 *       imageName: ${example.id}
 *       baseImage: base-image
 *   exampleDomain:
 *     type: aws:sagemaker:Domain
 *     name: example
 *     properties:
 *       domainName: example
 *       authMode: IAM
 *       vpcId: ${exampleAwsVpc.id}
 *       subnetIds:
 *         - ${exampleAwsSubnet.id}
 *       defaultUserSettings:
 *         executionRole: ${exampleAwsIamRole.arn}
 *         kernelGatewayAppSettings:
 *           customImages:
 *             - appImageConfigName: ${exampleAppImageConfig.appImageConfigName}
 *               imageName: ${exampleImageVersion.imageName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Domains using the `id`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/domain:Domain test_domain d-8jgsjtilstu8
 * ```
 */
public class Domain internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    /**
     * Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`. Valid values are `PublicInternetOnly` and `VpcOnly`.
     */
    public val appNetworkAccessType: Output<String>?
        get() = javaResource.appNetworkAccessType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The entity that creates and manages the required security groups for inter-app communication in `VPCOnly` mode. Valid values are `Service` and `Customer`.
     */
    public val appSecurityGroupManagement: Output<String>?
        get() = javaResource.appSecurityGroupManagement().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Domain.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The mode of authentication that members use to access the domain. Valid values are `IAM` and `SSO`.
     */
    public val authMode: Output<String>
        get() = javaResource.authMode().applyValue({ args0 -> args0 })

    /**
     * The default space settings. See `default_space_settings` Block below.
     */
    public val defaultSpaceSettings: Output<DomainDefaultSpaceSettings>?
        get() = javaResource.defaultSpaceSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> domainDefaultSpaceSettingsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The default user settings. See `default_user_settings` Block below.
     */
    public val defaultUserSettings: Output<DomainDefaultUserSettings>
        get() = javaResource.defaultUserSettings().applyValue({ args0 ->
            args0.let({ args0 ->
                domainDefaultUserSettingsToKotlin(args0)
            })
        })

    /**
     * The domain name.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * The domain settings. See `domain_settings` Block below.
     */
    public val domainSettings: Output<DomainDomainSettings>?
        get() = javaResource.domainSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> domainDomainSettingsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The ID of the Amazon Elastic File System (EFS) managed by this Domain.
     */
    public val homeEfsFileSystemId: Output<String>
        get() = javaResource.homeEfsFileSystemId().applyValue({ args0 -> args0 })

    /**
     * The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained. See `retention_policy` Block below.
     */
    public val retentionPolicy: Output<DomainRetentionPolicy>?
        get() = javaResource.retentionPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> domainRetentionPolicyToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The ID of the security group that authorizes traffic between the RSessionGateway apps and the RStudioServerPro app.
     */
    public val securityGroupIdForDomainBoundary: Output<String>
        get() = javaResource.securityGroupIdForDomainBoundary().applyValue({ args0 -> args0 })

    /**
     * The ARN of the application managed by SageMaker in IAM Identity Center. This value is only returned for domains created after September 19, 2023.
     */
    public val singleSignOnApplicationArn: Output<String>
        get() = javaResource.singleSignOnApplicationArn().applyValue({ args0 -> args0 })

    /**
     * The SSO managed application instance ID.
     */
    public val singleSignOnManagedApplicationInstanceId: Output<String>
        get() = javaResource.singleSignOnManagedApplicationInstanceId().applyValue({ args0 -> args0 })

    /**
     * The VPC subnets that Studio uses for communication.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The domain's URL.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })

    /**
     * The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
     * The following arguments are optional:
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.aws.sagemaker.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
